(function ( $ ) {
	'use strict';

	qodefCore.course = {};

	$( document ).ready(
		function () {
			qodefCourse.init();
		}
	);

	var qodefCourse = {
		init: function () {
			var $courseSingle = $( '.qodef-course-single' );

			if ( $courseSingle.length ) {
				qodefCore.shortcodes.warren_core_tabs.qodefTabs.init();
				qodefCourse.loginPopup( $courseSingle );
				qodefCourse.initPerfectScrollbar();
				qodefCourse.enroll( $courseSingle );
				qodefCourse.openCourse();
				qodefCourse.closeCourse();
				qodefCourse.retakeCourse( $courseSingle );
			}
		},
		loginPopup: function ( $courseSingle ) {
			var $button = $courseSingle.find( '.qodef-course-login' );

			if ( $button.length ) {
				$button.on(
					'click',
					function ( e ) {
						e.preventDefault();

						$( document.body ).trigger( 'warren_membership_trigger_login_modal' );
					}
				);
			}
		},
		initPerfectScrollbar: function () {
			var coursePopupHolderHeight = $( '#qodef-course-popup .qodef-course-popup-holder' ).height();
			var $coursePopupCurriculum  = $( '#qodef-course-popup .qodef-course-curriculum' );
			var $coursePopupContent     = $( '#qodef-course-popup .qodef-course-item-content-holder' );

			$coursePopupCurriculum.css(
				'max-height',
				coursePopupHolderHeight
			);
			$coursePopupContent.css(
				'max-height',
				coursePopupHolderHeight
			);

			if ( $coursePopupCurriculum.length && typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
				qodefCore.qodefPerfectScrollbar.init( $coursePopupCurriculum );
			}
		},
		enroll: function ( $courseSingle ) {
			var $enroll = $courseSingle.find( '.qodef-enroll' );

			if ( $enroll.length ) {
				$enroll.on(
					'click',
					function ( e ) {
						e.preventDefault();

						var $thisButton      = $( this );
						var $curriculum      = $( '#qodef-tab-curriculum .qodef-e-curriculum-sections' );
						var $popupCurriculum = $( '#qodef-course-popup .qodef-course-curriculum' );
						var $actionHolder    = $courseSingle.find( '.qodef-e-action-holder' );

						var ajaxData = {
							course_id: $thisButton.data( 'course-id' ),
						};

						$.ajax(
							{
								type: 'POST',
								url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getCourseEnrollRestRoute,
								data: {
									options: ajaxData,
								},
								beforeSend: function ( request ) {
									request.setRequestHeader(
										'X-WP-Nonce',
										qodefGlobal.vars.restNonce
									);
								},
								success: function ( response ) {

									if ( response.status === 'success' ) {

										$curriculum.html( response.data.curriculum );
										$popupCurriculum.html( response.data.curriculum );
										$actionHolder.html( response.data.progress );

										qodefCore.shortcodes.warren_core_progress_bar.qodefProgressBar.init();

										//to bind call on added links
										qodefCourse.openCourse();
									}
								},
								error: function ( response ) {
									console.log( response );
								}
							}
						);
					}
				);
			}
		},
		openCourse: function () {
			var $triggers = $( '.qodef-course-single .qodef-e-item-link, #qodef-course-popup .qodef-e-item-link' );

			if ( $triggers.length ) {
				$triggers.each(
					function () {
						var $this = $( this );

						if ( ! $this.hasClass( 'qodef-binded' ) ) {
							$this.addClass( 'qodef-binded' );

							$this.on(
								'click',
								function ( e ) {
									e.preventDefault();
									e.stopPropagation();

									var $thisButton               = $( this );
									var $coursePopup              = $( '#qodef-course-popup' );
									var $coursePopupContentHolder = $coursePopup.find( '.qodef-course-item-content-holder' );
									var $coursePopupContent       = $coursePopup.find( '.qodef-course-item-content' );
									var $coursePopupNavigation    = $coursePopup.find( '.qodef-course-item-navigation' );

									var ajaxData = {
										course_id: $thisButton.data( 'course-id' ),
										item_id: $thisButton.data( 'item-id' ),
										item_type: $thisButton.data( 'item-type' ),
									};

									//if course popup already opened - then qodef--loading class is required for loading animation
									if ( qodef.body.hasClass( 'qodef-cp-opened' ) ) {
										qodefCore.body.trigger(
											'warren_core_trigger_before_get_content',
											'#qodef-course-popup'
										);
										$coursePopup.addClass( 'qodef--loading' );
									}

									$.ajax(
										{
											type: 'GET',
											url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getCourseContentRestRoute,
											data: {
												options: ajaxData,
											},
											beforeSend: function ( request ) {
												request.setRequestHeader(
													'X-WP-Nonce',
													qodefGlobal.vars.restNonce
												);
											},
											success: function ( response ) {

												if ( response.status === 'success' ) {

													$coursePopupContent.html( response.data.html );
													$coursePopupNavigation.html( response.data.navigation );

													qodefCore.quiz.qodefQuiz.init();
													qodefCore.lesson.qodefLesson.init();

													//to bind call on added links
													qodefCourse.openCourse();
													$coursePopup.removeClass( 'qodef--loading' );

													if ( typeof qodefCore.qodefPerfectScrollbar === 'object' ) {
														$coursePopupContentHolder.scrollTop( 0 );
														qodefCore.qodefPerfectScrollbar.init( $coursePopupContentHolder );
													}

													if ( ! qodef.body.hasClass( 'qodef-cp-opened' ) ) {
														qodefCore.qodefScroll.disable();
														qodef.body.addClass( 'qodef-cp-opened' );
													}
												}
											},
											error: function ( response ) {
												console.log( response );
											}
										}
									);
								}
							);
						}
					}
				);
			}
		},
		closeCourse: function () {
			var $close = $( '#qodef-course-popup .qodef-cp-close' );

			$close.on(
				'click',
				function () {
					qodef.body.removeClass( 'qodef-cp-opened' );
					qodefCore.body.trigger(
						'warren_core_trigger_course_close',
						'#qodef-course-popup'
					);
					qodefCore.qodefScroll.enable();
				}
			);
		},
		retakeCourse: function ( $courseSingle ) {
			var $retake = $courseSingle.find( '.qodef-retake-course' );

			if ( $retake.length ) {
				$retake.on(
					'click',
					function ( e ) {
						e.preventDefault();

						var ajaxData = {
							course_id: $( this ).data( 'course-id' ),
						};

						$.ajax(
							{
								type: 'POST',
								url: qodefGlobal.vars.restUrl + qodefGlobal.vars.getRetakeCourseRestRoute,
								data: {
									options: ajaxData,
								},
								beforeSend: function ( request ) {
									request.setRequestHeader(
										'X-WP-Nonce',
										qodefGlobal.vars.restNonce
									);
								},
								success: function ( response ) {

									if ( response.status === 'success' ) {
										location.reload();
									}
								},
								error: function ( response ) {
									console.log( response );
								}
							}
						);
					}
				);
			}
		}
	};

	qodefCore.course.qodefCourse = qodefCourse;

})( jQuery );
