<?php

if ( ! function_exists( 'warren_core_add_course_curriculum_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_course_curriculum_meta_box( $page ) {
		if ( $page ) {
			$curriculum_tab = $page->add_tab_element(
				array(
					'name'  => 'tab-curriculum',
					'icon'  => 'fa fa-cog',
					'title' => esc_html__( 'Curriculum', 'warren-core' ),
				)
			);

			$curriculum_tab->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_course_syllabus',
					'title'       => esc_html__( 'Syllabus', 'warren-core' ),
					'description' => esc_html__( 'Enter course syllabus', 'warren-core' ),
				)
			);

			$section_repeater = $curriculum_tab->add_repeater_element(
				array(
					'name'  => 'qodef_course_curriculum_sections',
					'title' => esc_html__( 'Section', 'warren-core' ),
				)
			);

			$section_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_course_section_name',
					'title'      => esc_html__( 'Section Name', 'warren-core' ),
					'args'       => array(
						'col_width' => '6',
					),
				)
			);

			$section_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_course_section_title',
					'title'      => esc_html__( 'Section Title', 'warren-core' ),
					'args'       => array(
						'col_width' => '6',
					),
				)
			);

			$section_repeater->add_field_element(
				array(
					'field_type' => 'textarea',
					'name'       => 'qodef_course_section_description',
					'title'      => esc_html__( 'Section Description', 'warren-core' ),
				)
			);

			$subsection_repeater = $section_repeater->add_repeater_inner_element(
				array(
					'name' => 'qodef_course_curriculum_subsections',
				)
			);

			$lessons = qode_framework_get_cpt_items( 'lesson' );
			$quizzes = qode_framework_get_cpt_items( 'quiz' );

			$subsection_repeater->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_course_subsection_item',
					'title'      => esc_html__( 'Choose Item', 'warren-core' ),
					'options'    => array(
						'lesson' => esc_html__( 'Lesson', 'warren-core' ),
						'quiz'   => esc_html__( 'Quiz', 'warren-core' ),
					),
				)
			);

			$subsection_repeater->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_course_subsection_item_quiz',
					'title'      => esc_html__( 'Choose Quiz', 'warren-core' ),
					'options'    => $quizzes,
					'dependency' => array(
						'show' => array(
							'qodef_course_subsection_item' => array(
								'values'        => 'quiz',
								'default_value' => 'lesson',
							),
						),
					),
				)
			);
			$subsection_repeater->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_course_subsection_item_lesson',
					'title'      => esc_html__( 'Choose Lesson', 'warren-core' ),
					'options'    => $lessons,
					'dependency' => array(
						'show' => array(
							'qodef_course_subsection_item' => array(
								'values'        => 'lesson',
								'default_value' => 'lesson',
							),
						),
					),
				)
			);

		}
	}

	add_action( 'warren_core_action_after_course_meta_box_map', 'warren_core_add_course_curriculum_meta_box' );
}
