(function ( $ ) {
	'use strict';

	var shortcode = 'warren_core_course_list';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}
	$( document ).on(
		'warren_trigger_get_new_posts',
		function ( e, $holder, response, nextPage ) {
			if ( $holder.hasClass( 'qodef-course-list' ) ) {
				qodefInitCourseListSorting.initSortLabels(
					$holder,
					response,
					nextPage
				);
			}
		}
	);

	$( document ).ready(
		function () {
			qodefInitCourseListSorting.init();
		}
	);

	var qodefInitCourseListSorting = {
		init: function () {
			var $courseListSort = $( '.qodef-course-list .qodef-m-sorting' );

			if ( $courseListSort.length ) {
				$courseListSort.each(
					function () {
						var $thisSort = $( this ),
							$thisList = $thisSort.parents( '.qodef-course-list' );

						qodefInitCourseListSorting.defaultOptions( $thisList );
						qodefInitCourseListSorting.initSort(
							$thisList,
							$thisSort
						);
					}
				);
			}
		},
		initSortLabels: function ( $holder, response, nextPage ) {
			var $showingHolder = $holder.find( '.qodef-e-showing' ),
				$minHolder     = $showingHolder.find( '.qodef-e-min' ),
				$maxHolder     = $showingHolder.find( '.qodef-e-max' ),
				options        = $holder.data( 'options' ),
				minNumber      = options.posts_per_page * (nextPage - 1) + 1,
				maxNumber      = $holder.find( 'article' ).length + minNumber - 1;

			$minHolder.html( minNumber );
			$maxHolder.html( maxNumber );
		},
		defaultOptions: function ( $list ) {
			var options = $list.data( 'options' );

			var defaultOptions = {
				orderby: options.orderby,
				order: options.order,
			};

			$list.data(
				'default-options',
				defaultOptions
			);
		},
		initSort: function ( $list, $sort ) {
			var $sortSelect    = $sort.find( 'select' ),
				options        = $list.data( 'options' ),
				defaultOptions = $list.data( 'default-options' );

			$sortSelect.on(
				'change',
				function () {
					var sorting = $( this ).val();

					switch (sorting) {
						case 'default':
							options.orderby = defaultOptions.orderby;
							options.order   = defaultOptions.order;
							break;
						case 'newest':
							options.orderby = 'date';
							options.order   = 'DESC';
							break;
						case 'az':
							options.orderby = 'title';
							options.order   = 'ASC';
							break;
						case 'za':
							options.orderby = 'title';
							options.order   = 'DESC';
							break;
					}

					$list.data( 'options', options );

					qodef.body.trigger( 'warren_trigger_load_more', [$list, 1] );
				}
			);
		}
	};

	qodefCore.shortcodes[shortcode].qodefInitCourseListSorting = qodefInitCourseListSorting;

})( jQuery );
