<?php

if ( ! function_exists( 'warren_core_course_list_filter_query' ) ) {
	/**
	 * Function to adjust query for listing list parameters
	 *
	 * @param $args
	 * @param $params
	 *
	 * @return mixed
	 */
	function warren_core_course_list_filter_query( $args, $params ) {
		if ( 'course' === $args['post_type'] ) {
			switch ( $params['orderby'] ) {
				case 'course-featured':
					//to get posts by featured, and afterwards when featured is not set
					$meta_query = array(
						'relation' => 'OR',
						'featured' => array(
							'key'     => 'qodef_course_featured',
							'value'   => array( 'yes', 'no', '' ),
							'compare' => 'IN',
						),
						'rest'     => array(
							'key'     => 'qodef_course_featured',
							'value'   => 'exists',
							'compare' => 'NOT EXISTS',
						),
					);

					$args['order']   = 'DESC';
					$args['orderby'] = 'meta_value date';
					break;

				case 'price-high':
					$meta_query = array(
						array(
							'key'     => 'qodef_course_final_price',
							'value'   => '0',
							'compare' => '>=',
							'type'    => 'NUMERIC',
						),
					);

					$args['order']   = 'DESC';
					$args['orderby'] = 'meta_value';
					break;

				case 'price-low':
					$meta_query = array(
						array(
							'key'     => 'qodef_course_final_price',
							'value'   => '0',
							'compare' => '>=',
							'type'    => 'NUMERIC',
						),
					);

					$args['order']   = 'ASC';
					$args['orderby'] = 'meta_value';
					break;
			}

			if ( isset( $meta_query ) ) {
				if ( isset( $args['meta_query'] ) ) {
					$args['meta_query'] = array(
						'RELATION' => 'AND',
						$meta_query,
						$args['meta_query'],
					);
				} else {
					$args['meta_query'] = $meta_query;
				}
			}
		}

		return $args;
	}

	add_filter( 'warren_filter_query_params', 'warren_core_course_list_filter_query', 10, 2 );
}
