<?php

if ( ! function_exists( 'warren_core_add_course_search_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function warren_core_add_course_search_shortcode( $shortcodes ) {
		$shortcodes[] = 'WarrenCore_Course_Search_Shortcode';

		return $shortcodes;
	}

	add_filter( 'warren_core_filter_register_shortcodes', 'warren_core_add_course_search_shortcode' );
}

if ( class_exists( 'WarrenCore_Shortcode' ) ) {
	class WarrenCore_Course_Search_Shortcode extends WarrenCore_Shortcode {

		public function __construct() {
			$this->set_layouts( apply_filters( 'warren_core_filter_course_search_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'warren_core_filter_course_search_extra_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( WARREN_CORE_PLUGINS_URL_PATH . '/lms/post-types/course/shortcodes/course-search' );
			$this->set_base( 'warren_core_course_search' );
			$this->set_name( esc_html__( 'Course Search', 'warren-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds course search element', 'warren-core' ) );
			$this->set_scripts(
				array(
					'select2' => array(
						'registered' => false,
						'url'        => QODE_FRAMEWORK_INC_URL_PATH . '/common/assets/plugins/select2/select2.full.min.js',
						'dependency' => array(),
					),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'enable_category',
					'title'      => esc_html__( 'Enable category as parameter for search', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'enable_instructor',
					'title'      => esc_html__( 'Enable instructor as parameter for search', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'enable_price',
					'title'      => esc_html__( 'Enable price as parameter for search', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'text',
					'name'          => 'button_text',
					'title'         => esc_html__( 'Button Text', 'warren-core' ),
					'default_value' => esc_html__( 'Search', 'warren-core' ),
				)
			);
		}

		public function load_assets() {
			wp_enqueue_script( 'select2' );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );

			return warren_core_get_template_part( 'plugins/lms/post-types/course/shortcodes/course-search', 'templates/search', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-course-search';

			return implode( ' ', $holder_classes );
		}
	}
}
