<?php

if ( have_posts() ) {
	while ( have_posts() ) :
		the_post();

		// Hook to include additional content before post item
		do_action( 'warren_core_action_before_course_single' );

		$item_layout = apply_filters( 'warren_core_filter_course_single_layout', array() );
		$params      = warren_core_get_course_params();

		// Include post item
		warren_core_template_part( 'plugins/lms/post-types/course', 'templates/layouts/' . $item_layout, '', $params );

		// Hook to include additional content after post item
		do_action( 'warren_core_action_after_course_single' );

	endwhile; // End of the loop.
} else {
	// Include global posts not found
	warren_core_theme_template_part( 'content', 'templates/parts/posts-not-found' );
}

wp_reset_postdata();
