<?php
$course_categories = wp_get_post_terms( get_the_ID(), 'course-category' );

if ( ! empty( $course_categories ) ) { ?>
	<div class="qodef-e-course-info qodef-e-info--categories">
		<?php
		$only_parent = 'yes' === warren_core_get_option_value( 'admin', 'qodef_course_single_show_only_parent_category' );

		if ( $only_parent ) {
			foreach ( $course_categories as $id => $term ) {
				if ( 0 !== $term->parent ) {
					unset( $course_categories[ $id ] );
				}
			}
		}
		?>
		<h6 class="qodef-e-title"><?php esc_html_e( 'Category ', 'warren-core' ); ?></h6>
		<div class="qodef-e-categories">
			<?php foreach ( $course_categories as $cat ) { ?>
				<a itemprop="url" class="qodef-e-category" href="<?php echo esc_url( get_term_link( $cat->term_id ) ); ?>">
					<?php echo esc_html( $cat->name ); ?>
				</a>
			<?php } ?>
		</div>
	</div>
<?php } ?>
