<?php
$course_id           = ! empty( $course_id ) ? $course_id : get_the_ID();
$curriculum_sections = get_post_meta( $course_id, 'qodef_course_curriculum_sections', true );
$course_status       = warren_core_get_course_status( $course_id );

if ( ! empty( $curriculum_sections ) && count( $curriculum_sections ) ) {
	foreach ( $curriculum_sections as $section ) {
		$name        = $section['qodef_course_section_name'];
		$title       = $section['qodef_course_section_title'];
		$description = $section['qodef_course_section_description'];



		if ( isset ( $section['qodef_course_curriculum_subsections'] ) ) {
			$count_sub    = count( $section['qodef_course_curriculum_subsections'] );
			$section_info = warren_core_course_section_info_count( $section['qodef_course_curriculum_subsections'] );
		} else {
			$count_sub    = '';
			$section_info = '';
		}

		?>
		<div class="qodef-e-curriculum-section">
			<div class="qodef-e-top-holder">
				<h4 class="qodef-e-name"><?php echo esc_html( $name ); ?></h4>
				<span class="qodef-e-count"><?php echo esc_html( $count_sub ); ?></span>
			</div>
			<h5 class="qodef-e-title"><?php echo esc_html( $title ); ?></h5>
			<p class="qodef-e-description">
				<?php echo esc_html( $description ); ?>
			</p>
			<div class="qodef-e-subsection-counter">
				<?php
				foreach ( $section_info as $info ) {
					if ( $info['count'] > 0 ) {
						?>
						<div class="qodef-e-count-subsections"><?php echo esc_html( $info['count'] . ' ' . $info['label'] ); ?></div>
						<?php
					}
				}
				?>
			</div>
			<div class="qodef-e-curriculum-subsections">
				<?php
				foreach ( $section['qodef_course_curriculum_subsections'] as $subsection ) {
					$subsection['status']    = $course_status;
					$subsection['course_id'] = $course_id;

					// Get item curriculum subsection
					warren_core_template_part( 'plugins/lms/post-types/course', 'templates/parts/post-info/' . $subsection['qodef_course_subsection_item'], '', $subsection );
				}
				?>
			</div>
		</div>
		<?php
	}
}