<?php

$quiz_id = ! empty( $qodef_course_subsection_item_quiz ) ? $qodef_course_subsection_item_quiz : 0;

if ( ! empty( $quiz_id ) ) {
	$quiz_title     = get_the_title( $quiz_id );
	$quiz_questions = is_array(get_post_meta( $quiz_id, 'qodef_quiz_questions', true )) ? count( get_post_meta( $quiz_id, 'qodef_quiz_questions', true ) ) : 0;
	$quiz_label     = esc_html__( 'question', 'warren-core' );
	$visible        = false;


	if ( $quiz_questions > 1 ) {
		$quiz_label = esc_html__( 'questions', 'warren-core' );
	}

	if ( 'enrolled' === $status ) {
		$visible = true;
	}
	?>
	<div class="qodef-e-quiz">
		<div class="qodef-e-title-holder">
			<span class="qodef-e-label"><?php esc_html_e( 'Graded:', 'warren-core' ); ?></span>
			<span class="qodef-e-quiz-title">
				<?php if ( $visible ) { ?>
					<a href="#" class="qodef-e-item-link" data-item-id="<?php echo esc_attr( $quiz_id ); ?>" data-item-type="<?php echo 'quiz'; ?>" data-course-id="<?php echo esc_attr( $course_id ); ?>">
				<?php } ?>
				<?php echo esc_html( $quiz_title ); ?>
				<?php if ( $visible ) { ?>
					</a>
				<?php } ?>
			</span>
		</div>
		<div class="qodef-e-quiz-duration">
			<?php echo esc_html( $quiz_questions . ' ' . $quiz_label ); ?>
		</div>
	</div>
	<?php
}
?>
