<?php

$user_id      = ! empty( $user_id ) ? $user_id : get_current_user_id();
$course_id    = ! empty( $course_id ) ? $course_id : get_the_ID();
$course_info  = get_user_meta( $user_id, 'qodef_course_' . $course_id, true );
$percentage   = 0;
$retakes      = 0;
$allow_retake = false;

if ( ! empty( $course_info ) ) {
	$percentage = $course_info['percentage'];
	$retakes    = $course_info['retakes'];

	if ( count( $course_info['quizzes'] ) ) {
		foreach ( $course_info['quizzes'] as $quiz_id => $quiz_info ) {
			$max_takes = intval( get_post_meta( $quiz_id, 'qodef_quiz_retakes_number', true ) );

			if ( 'no' === $quiz_info['passed'] && intval( $quiz_info['takes'] ) > $max_takes ) {
				$allow_retake = true;
				break;
			}
		}
	}

	if ( 100 == $percentage ) {
		$allow_retake = true;
	}
}

$progress_params = array(
	'layout' => 'line',
	'number' => $percentage,
);

$retake_params = array();
if ( $allow_retake ) {
	$retakes_allowed = get_post_meta( $course_id, 'qodef_course_retake_number', true );
	if ( empty( $retakes_allowed ) || $retakes_allowed > $retakes ) {
		$retake_params = array(
			'text'         => esc_html__( 'Retake Course', 'warren-core' ),
			'custom_class' => 'qodef-retake-course',
			'button_layout' => 'outlined',
			'custom_attrs' => array(
				'data-course-id' => $course_id,
			),
		);
	}
}
?>
<div class="qodef-e-progress-holder">
	<?php
	echo WarrenCore_Progress_Bar_Shortcode::call_shortcode( $progress_params );

	if ( count( $retake_params ) ) {
		?>
		<div class="qodef-e-retake-holder">
			<?php echo WarrenCore_Button_Shortcode::call_shortcode( $retake_params ); ?>
		</div>
	<?php } ?>
</div>
