<?php

if ( ! function_exists( 'warren_core_add_course_info_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_core_add_course_info_widget( $widgets ) {
		$widgets[] = 'WarrenCore_Course_Info_Widget';

		return $widgets;
	}

	add_filter( 'warren_core_filter_register_widgets', 'warren_core_add_course_info_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenCore_Course_Info_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_base( 'warren_core_course_info' );
			$this->set_name( esc_html__( 'Warren Course Info', 'warren-core' ) );
			$this->set_description( esc_html__( 'Add course info element into widget areas', 'warren-core' ) );

			$this->set_widget_option(
				array(
					'field_type' => 'text',
					'name'       => 'widget_title',
					'title'      => esc_html__( 'Widget Title', 'warren-core' ),
				)
			);

			$this->set_widget_option(
				array(
					'field_type'  => 'text',
					'name'        => 'course_id',
					'title'       => esc_html__( 'Course ID', 'warren-core' ),
					'description' => esc_html__( 'Enter course ID, if ID not set, current page ID will be taken', 'warren-core' ),
				)
			);

			$this->set_widget_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_course_duration',
					'title'      => esc_html__( 'Show Course Duration', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);

			$this->set_widget_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_course_maximum_students',
					'title'      => esc_html__( 'Show Course Maximum Students', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'no_yes', false ),
				)
			);

			$this->set_widget_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_course_retakes_number',
					'title'      => esc_html__( 'Show Course Number of Retakes', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);

			$this->set_widget_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_course_passing_percentage',
					'title'      => esc_html__( 'Show Course Passing Percentage', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);

			$this->set_widget_option(
				array(
					'field_type' => 'select',
					'name'       => 'show_course_curriculum_info',
					'title'      => esc_html__( 'Show Course Curriculum Info', 'warren-core' ),
					'options'    => warren_core_get_select_type_options_pool( 'yes_no', false ),
				)
			);
		}

		public function render( $atts ) {
			$course_id = get_the_ID();

			if ( ! empty( $atts['course_id'] ) ) {
				$course_id = $atts['course_id'];
			}

			if ( 'course' !== get_post_type( $course_id ) ) {
				return esc_html__( 'Please enter ID of the course wanted.', 'warren-core' );
			}

			$course_duration           = get_post_meta( $course_id, 'qodef_course_duration', true );
			$course_duration_unit      = get_post_meta( $course_id, 'qodef_course_duration_unit', true );
			$course_maximum_students   = get_post_meta( $course_id, 'qodef_course_maximum_students', true );
			$course_retakes            = get_post_meta( $course_id, 'qodef_course_retake_number', true );
			$course_passing_percentage = get_post_meta( $course_id, 'qodef_course_passing_percentage', true );
			$course_sections           = get_post_meta( $course_id, 'qodef_course_curriculum_sections', true );
			$course_duration_label     = warren_core_lms_get_duration_label( $course_duration, $course_duration_unit );
			$course_lesson_quiz        = warren_core_course_curriculum_info( $course_sections );

			$info_params = array(
				'duration'               => array(
					'label' => esc_html__( 'Duration: ', 'warren-core' ),
					'info'  => $course_duration . ' ' . $course_duration_label,
				),
				'maximum_students'       => array(
					'label' => esc_html__( 'Maximum Students: ', 'warren-core' ),
					'info'  => $course_maximum_students,
				),
				'retakes_number'         => array(
					'label' => esc_html__( 'Max Retakes: ', 'warren-core' ),
					'info'  => $course_retakes,
				),
				'passing_percentage'     => array(
					'label' => esc_html__( 'Pass Percentage: ', 'warren-core' ),
					'info'  => $course_passing_percentage,
				),
				'curriculum_info_lesson' => array(
					'label' => $course_lesson_quiz['lesson']['label'],
					'info'  => $course_lesson_quiz['lesson']['count'],
				),
				'curriculum_info_quiz'   => array(
					'label' => $course_lesson_quiz['quiz']['label'],
					'info'  => $course_lesson_quiz['quiz']['count'],
				),
			);

			?>
			<div class="widget qodef-course-info">
				<?php
				foreach ( $info_params as $key => $info ) {
					if ( 'curriculum_info_lesson' === $key || 'curriculum_info_quiz' === $key ) {
						$key = 'curriculum_info';
					}
					if ( 'yes' === $atts[ 'show_course_' . $key ] ) {
						warren_core_template_part( 'plugins/lms/post-types/course', 'widgets/course-info/templates/parts/info', '', $info );
					}
				}
				?>
			</div>
			<?php
		}
	}
}
