<?php

if ( ! function_exists( 'warren_core_lms_post_types' ) ) {
	function warren_core_lms_post_types( $class ) {
		foreach ( glob( WARREN_CORE_PLUGINS_PATH . '/lms/post-types/*', GLOB_ONLYDIR ) as $post_type ) {

			if ( 'dashboard' !== basename( $post_type ) ) {
				$is_disabled = warren_core_performance_get_option_value( $post_type, 'warren_core_performance_post_type_' );

				if ( empty( $is_disabled ) ) {
					$class->set_allowed_post_types( $post_type );
				}
			}
		}
	}

	add_action( 'warren_core_action_add_custom_post_type', 'warren_core_lms_post_types' );
}
