<?php

if ( ! function_exists( 'warren_core_add_lesson_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_lesson_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'lesson' ),
				'type'  => 'meta',
				'slug'  => 'lesson',
				'title' => esc_html__( 'Lesson Section', 'warren-core' ),
			)
		);

		if ( $page ) {

			$general_tab = $page->add_tab_element(
				array(
					'name'  => 'tab-general',
					'icon'  => 'fa fa-cog',
					'title' => esc_html__( 'General', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_lesson_type',
					'title'         => esc_html__( 'Lesson Type', 'warren-core' ),
					'default_value' => 'reading',
					'options'       => array(
						'reading' => esc_html__( 'Reading', 'warren-core' ),
						'audio'   => esc_html__( 'Audio', 'warren-core' ),
						'video'   => esc_html__( 'Video', 'warren-core' ),
					),
				)
			);

			$audio_section = $general_tab->add_section_element(
				array(
					'name'       => 'qodef_lesson_audio_section',
					'title'      => esc_html__( 'Audio', 'warren-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_lesson_type' => array(
								'values'        => 'audio',
								'default_value' => 'reading',
							),
						),
					),
				)
			);

			$audio_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_lesson_audio_url',
					'title'       => esc_html__( 'Audio URL', 'warren-core' ),
					'description' => esc_html__( 'Input your audio link here. Here are all the supported audio formats https://wordpress.org/support/article/audio-shortcode/#options  https://wordpress.org/support/article/embeds/#okay-so-what-sites-can-i-embed-from', 'warren-core' ),
				)
			);

			$video_section = $general_tab->add_section_element(
				array(
					'name'       => 'qodef_lesson_video_section',
					'title'      => esc_html__( 'Video', 'warren-core' ),
					'dependency' => array(
						'show' => array(
							'qodef_lesson_type' => array(
								'values'        => 'video',
								'default_value' => 'reading',
							),
						),
					),
				)
			);

			$video_section->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_lesson_video_url',
					'title'       => esc_html__( 'Video URL', 'warren-core' ),
					'description' => esc_html__( 'Input your video link here. Here are all the supported video formats https://wordpress.org/support/article/video-shortcode/#options  https://wordpress.org/support/article/embeds/#okay-so-what-sites-can-i-embed-from', 'warren-core' ),
				)
			);

			$duration_row = $general_tab->add_row_element(
				array(
					'name' => 'qodef_lesson_duration_row',
				)
			);

			$duration_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_lesson_duration',
					'title'      => esc_html__( 'Lesson Duration', 'warren-core' ),
					'args'       => array(
						'col_width' => 6,
					),
				)
			);

			$duration_row->add_field_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_lesson_duration_unit',
					'title'      => esc_html__( 'Lesson Duration Unit', 'warren-core' ),
					'options'    => array(
						'minutes' => esc_html__( 'Minutes', 'warren-core' ),
						'hours'   => esc_html__( 'Hours', 'warren-core' ),
						'days'    => esc_html__( 'Days', 'warren-core' ),
						'weeks'   => esc_html__( 'Weeks', 'warren-core' ),
					),
					'args'       => array(
						'col_width' => 6,
					),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_lesson_free',
					'title'         => esc_html__( 'Free Lesson', 'warren-core' ),
					'description'   => esc_html__( 'Enabling this option will set lesson to be free', 'warren-core' ),
					'default_value' => 'no',
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_lesson_completed_message',
					'title'       => esc_html__( 'Lesson Completed Message', 'warren-core' ),
					'description' => esc_html__( 'Enter message that will be displayed after the lesson is completed', 'warren-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_lesson_meta_box_map', $page );
		}
	}

	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_add_lesson_meta_box', 1 );
}
