<?php

if ( ! function_exists( 'warren_core_add_rest_api_lesson_global_variables' ) ) {
	/**
	 * Extend main rest api variables with new case
	 *
	 * @param array $global - list of variables
	 * @param string $namespace - rest namespace url
	 *
	 * @return array
	 */
	function warren_core_add_rest_api_lesson_global_variables( $global, $namespace ) {
		$global['getLessonCompleteRestRoute'] = $namespace . '/lesson-complete';

		return $global;
	}

	add_filter( 'warren_filter_rest_api_global_variables', 'warren_core_add_rest_api_lesson_global_variables', 10, 2 );
}

if ( ! function_exists( 'warren_core_add_rest_api_lesson_route' ) ) {
	/**
	 * Extend main rest api routes with new case
	 *
	 * @param array $routes - list of rest routes
	 *
	 * @return array
	 */
	function warren_core_add_rest_api_lesson_route( $routes ) {
		$routes['lesson-complete'] = array(
			'route'               => 'lesson-complete',
			'methods'             => WP_REST_Server::CREATABLE,
			'callback'            => 'warren_core_complete_lesson',
			'permission_callback' => function () {
				return is_user_logged_in();
			},
			'args'                => array(
				'options' => array(
					'required'          => true,
					'validate_callback' => function ( $param, $request, $key ) {
						return is_array( $param ) ? $param : (array) $param;
					},
					'description'       => esc_html__( 'Options is required parameter', 'warren-core' ),
				),
			),
		);

		return $routes;
	}

	add_filter( 'warren_filter_rest_api_routes', 'warren_core_add_rest_api_lesson_route' );
}

if ( ! function_exists( 'warren_core_complete_lesson' ) ) {
	function warren_core_complete_lesson() {

		if ( ! isset( $_POST['options'] ) || empty( $_POST['options'] ) ) {
			qode_framework_get_ajax_status( 'error', esc_html__( 'Get method is invalid', 'warren-core' ) );
		} else {
			$options = array_filter( array_map( 'esc_attr', $_POST['options'] ) );
			$user_id = get_current_user_id();

			$course_info = get_user_meta( $user_id, 'qodef_course_' . $options['course_id'], true );

			$new_percentage            = warren_core_calculate_course_percentage( $course_info );
			$course_info['percentage'] = $new_percentage;
			$course_passing_percentage = get_post_meta( $options['course_id'], 'qodef_course_passing_percentage', true );

			if ( 100 === intval( $new_percentage ) ) {
				$course_info['status'] = 'completed';
			}
			if ( intval( $course_passing_percentage ) <= intval( $new_percentage ) ) {
				$course_info['passed'] = 'yes';
			}

			$course_info['lessons'][ $options['lesson_id'] ]['status'] = 'completed';

			$updated = warren_core_update_user_course_info( $user_id, $options['course_id'], $course_info );

			if ( $updated ) {
				$lesson_message = get_post_meta( $options['lesson_id'], 'qodef_lesson_completed_message', true );
				if ( empty( $lesson_message ) ) {
					$lesson_message = esc_html__( 'Lesson completed!', 'warren-core' );
				}

				$data = array(
					'message'    => $lesson_message,
					'percentage' => $course_info['percentage'],
				);

				qode_framework_get_ajax_status( 'success', esc_html__( 'Lesson completed.', 'warren-core' ), $data );
			} else {
				qode_framework_get_ajax_status( 'error', esc_html__( 'Lesson not completed', 'warren-core' ) );
			}
		}
	}
}
