<?php
$audio_meta = get_post_meta( $lesson_id, 'qodef_lesson_audio_url', true );

if ( ! empty( $audio_meta ) ) {
	$oembed = wp_oembed_get( $audio_meta );
	if ( ! empty( $oembed ) ) {
		echo wp_oembed_get( $audio_meta );
	} else { ?>
		<div class="qodef-e-media">
			<?php if ( has_post_thumbnail( $lesson_id ) ) { ?>
				<div class="qodef-e-media-image">
					<?php echo get_the_post_thumbnail( $lesson_id, 'full' ); ?>
				</div>
			<?php } ?>
			<div class="qodef-e-media-audio">
				<?php
				// Audio player settings
				$settings = apply_filters( 'warren_filter_audio_post_format_settings', array() );

				// Init audio player
				echo wp_audio_shortcode( array_merge( array( 'src' => esc_url( $audio_meta ) ), $settings ) );
				?>
			</div>
		</div>
	<?php }
} ?>
