<?php

if ( ! function_exists( 'warren_core_add_question_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_question_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'question' ),
				'type'  => 'meta',
				'slug'  => 'question',
				'title' => esc_html__( 'Question Section', 'warren-core' ),
			)
		);

		if ( $page ) {

			$general_tab = $page->add_tab_element(
				array(
					'name'  => 'tab-general',
					'icon'  => 'fa fa-cog',
					'title' => esc_html__( 'General', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type' => 'textarea',
					'name'       => 'qodef_question_description',
					'title'      => esc_html__( 'Question Description', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_question_type',
					'title'         => esc_html__( 'Question Type', 'warren-core' ),
					'options'       => array(
						'choice'  => esc_html__( 'Choice', 'warren-core' ),
						'textual' => esc_html__( 'Textual', 'warren-core' ),
					),
					'default_value' => 'choice',
				)
			);

			$choice_section = $general_tab->add_section_element(
				array(
					'name'       => 'qodef_question_choice_answer_section',
					'dependency' => array(
						'show' => array(
							'qodef_question_type' => array(
								'values'        => 'choice',
								'default_value' => 'choice',
							),
						),
					),
				)
			);

			$answers_repeater = $choice_section->add_repeater_element(
				array(
					'name'        => 'qodef_question_answers_repeater',
					'title'       => esc_html__( 'Answer', 'warren-core' ),
					'button_text' => esc_html__( 'Add New Answer', 'warren-core' ),
				)
			);

			$answers_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_question_answer_text',
					'title'      => esc_html__( 'Answer Text', 'warren-core' ),
					'args'       => array(
						'col_width' => '9',
					),
				)
			);

			$answers_repeater->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_question_answer_correct',
					'title'         => esc_html__( 'Correct?', 'warren-core' ),
					'default_value' => 'no',
					'options'       => warren_core_get_select_type_options_pool( 'no_yes', false ),
					'args'          => array(
						'col_width' => '3',
					),
				)
			);

			$textual_section = $general_tab->add_section_element(
				array(
					'name'       => 'qodef_question_textual_answer_section',
					'dependency' => array(
						'hide' => array(
							'qodef_question_type' => array(
								'values'        => 'choice',
								'default_value' => 'choice',
							),
						),
					),
				)
			);

			$textual_section->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_question_textual_answer',
					'title'       => esc_html__( 'Answer', 'warren-core' ),
					'description' => esc_html__( 'Enter correct answer', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_question_description',
					'title'       => esc_html__( 'Question Description', 'warren-core' ),
					'description' => esc_html__( 'Enter question description', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_question_points',
					'title'       => esc_html__( 'Question Points', 'warren-core' ),
					'description' => esc_html__( 'Enter number of points given for correct answer', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_question_hint',
					'title'       => esc_html__( 'Question Hint', 'warren-core' ),
					'description' => esc_html__( 'Set hint that can be displayed to student', 'warren-core' ),
				)
			);

			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_question_meta_box_map', $page );
		}
	}

	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_add_question_meta_box', 1 );
}
