<?php

if ( ! function_exists( 'warren_core_add_rest_api_question_global_variables' ) ) {
	/**
	 * Extend main rest api variables with new case
	 *
	 * @param array $global - list of variables
	 * @param string $namespace - rest namespace url
	 *
	 * @return array
	 */
	function warren_core_add_rest_api_question_global_variables( $global, $namespace ) {
		$global['getQuestionHintRestRoute']        = $namespace . '/question-hint';
		$global['getQuestionCheckAnswerRestRoute'] = $namespace . '/question-check-answer';
		$global['getQuestionNextRestRoute']        = $namespace . '/question-next';

		return $global;
	}

	add_filter( 'warren_filter_rest_api_global_variables', 'warren_core_add_rest_api_question_global_variables', 10, 2 );
}

if ( ! function_exists( 'warren_core_add_rest_api_question_route' ) ) {
	/**
	 * Extend main rest api routes with new case
	 *
	 * @param array $routes - list of rest routes
	 *
	 * @return array
	 */
	function warren_core_add_rest_api_question_route( $routes ) {
		$routes['question-hint']         = array(
			'route'               => 'question-hint',
			'methods'             => WP_REST_Server::READABLE,
			'callback'            => 'warren_core_get_question_hint',
			'permission_callback' => function () {
				return is_user_logged_in();
			},
			'args'                => array(
				'options' => array(
					'required'          => true,
					'validate_callback' => function ( $param, $request, $key ) {
						return is_array( $param ) ? $param : (array) $param;
					},
					'description'       => esc_html__( 'Options is required parameter', 'warren-core' ),
				),
			),
		);
		$routes['question-check-answer'] = array(
			'route'               => 'question-check-answer',
			'methods'             => WP_REST_Server::CREATABLE,
			'callback'            => 'warren_core_check_question_answer',
			'permission_callback' => function () {
				return is_user_logged_in();
			},
			'args'                => array(
				'options' => array(
					'required'          => true,
					'validate_callback' => function ( $param, $request, $key ) {
						return is_array( $param ) ? $param : (array) $param;
					},
					'description'       => esc_html__( 'Options is required parameter', 'warren-core' ),
				),
			),
		);
		$routes['question-next']         = array(
			'route'               => 'question-next',
			'methods'             => WP_REST_Server::CREATABLE,
			'callback'            => 'warren_core_get_question_next',
			'permission_callback' => function () {
				return is_user_logged_in();
			},
			'args'                => array(
				'options' => array(
					'required'          => true,
					'validate_callback' => function ( $param, $request, $key ) {
						return is_array( $param ) ? $param : (array) $param;
					},
					'description'       => esc_html__( 'Options is required parameter', 'warren-core' ),
				),
			),
		);

		return $routes;
	}

	add_filter( 'warren_filter_rest_api_routes', 'warren_core_add_rest_api_question_route' );
}

if ( ! function_exists( 'warren_core_get_question_hint' ) ) {
	function warren_core_get_question_hint() {

		if ( ! isset( $_GET['options'] ) || empty( $_GET['options'] ) ) {
			qode_framework_get_ajax_status( 'error', esc_html__( 'Get method is invalid', 'warren-core' ) );
		} else {
			$options = array_filter( array_map( 'esc_attr', $_GET['options'] ) );

			$hint = get_post_meta( $options['question_id'], 'qodef_question_hint', true );

			$data = array(
				'hint' => $hint,
			);

			qode_framework_get_ajax_status( 'success', esc_html__( 'Hint revealed.', 'warren-core' ), $data );
		}
	}
}

if ( ! function_exists( 'warren_core_check_question_answer' ) ) {
	function warren_core_check_question_answer() {

		if ( ! isset( $_POST['options'] ) || empty( $_POST['options'] ) ) {
			qode_framework_get_ajax_status( 'error', esc_html__( 'Get method is invalid', 'warren-core' ) );
		} else {
			$options = array_filter( array_map( 'esc_attr', $_POST['options'] ) );
			$user_id = get_current_user_id();

			$answer = warren_core_question_get_answer( $options['question_id'] );

			$course_info = get_user_meta( $user_id, 'qodef_course_' . $options['course_id'], true );

			$course_info['quizzes'][ $options['quiz_id'] ]['questions'][ $options['question_id'] ]['checked'] = 'yes';

			warren_core_update_user_course_info( $user_id, $options['course_id'], $course_info );

			$data = array(
				'answer' => $answer,
			);

			qode_framework_get_ajax_status( 'success', esc_html__( 'Answer checked.', 'warren-core' ), $data );
		}
	}
}

if ( ! function_exists( 'warren_core_question_get_answer' ) ) {
	function warren_core_question_get_answer( $question_id ) {
		$answer        = array();
		$question_type = get_post_meta( $question_id, 'qodef_question_type', true );

		if ( 'choice' === $question_type ) {
			$questions_answers = get_post_meta( $question_id, 'qodef_question_answers_repeater', true );
			foreach ( $questions_answers as $questions_answer ) {
				if ( 'yes' === $questions_answer['qodef_question_answer_correct'] ) {
					$answer[] = trim( $questions_answer['qodef_question_answer_text'] );
				}
			}
		} else {
			$answer[] = trim( get_post_meta( $question_id, 'qodef_question_textual_answer', true ) );
		}

		return $answer;
	}
}

if ( ! function_exists( 'warren_core_get_question_next' ) ) {
	function warren_core_get_question_next() {

		if ( ! isset( $_POST['options'] ) || empty( $_POST['options'] ) ) {
			qode_framework_get_ajax_status( 'error', esc_html__( 'Get method is invalid', 'warren-core' ) );
		} else {
			$options = array_filter( array_map( 'esc_attr', $_POST['options'] ) );
			$user_id = get_current_user_id();

			$course_info = get_user_meta( $user_id, 'qodef_course_' . $options['course_id'], true );

			if ( isset( $options['answers'] ) && ! empty( $options['answers'] ) ) {
				$course_info['quizzes'][ $options['quiz_id'] ]['questions'][ $options['question_id'] ]['current_answer'] = $options['answers'];
			}

			if ( ! isset( $options['question'] ) ) {
				$options['question'] = 0;
			}

			$course_info['quizzes'][ $options['quiz_id'] ]['current_question'] = $options['question'];
			warren_core_update_user_course_info( $user_id, $options['course_id'], $course_info );

			$html = warren_core_get_template_part( 'plugins/lms/post-types/question', 'templates/content', '', $options );

			$data = array(
				'html' => $html,
			);

			qode_framework_get_ajax_status( 'success', esc_html__( 'Next question added.', 'warren-core' ), $data );
		}
	}
}
