<?php
$question  = isset( $question ) ? $question : 0;
$questions = get_post_meta( $quiz_id, 'qodef_quiz_questions', true );

$current_question_id  = $questions[ $question ]['qodef_quiz_question'];
$question_title       = get_the_title( $current_question_id );
$question_type        = get_post_meta( $current_question_id, 'qodef_question_type', true );
$question_description = get_post_meta( $current_question_id, 'qodef_question_description', true );
$course_info          = get_user_meta( get_current_user_id(), 'qodef_course_' . $course_id, true );
$current_answer       = $course_info['quizzes'][ $quiz_id ]['questions'][ $current_question_id ]['current_answer'];
$checked              = $course_info['quizzes'][ $quiz_id ]['questions'][ $current_question_id ]['checked'];
$prev_question        = false;
$next_question        = false;

if ( 0 <= $question - 1 ) {
	$prev_question = $question - 1;
}

if ( count( $questions ) > $question + 1 ) {
	$next_question = $question + 1;
}

$hint_params = array(
	'text'         => esc_html__( 'Hint', 'warren-core' ),
	'custom_class' => 'qodef-question-hint',
);

$check_params = array(
	'text'         => esc_html__( 'Check Answer', 'warren-core' ),
	'custom_class' => 'qodef-question-check',
);

if ( 'yes' === $checked ) {
	$check_params['custom_class'] .= ' qodef--disable';
}

$prev_params = array(
	'text'         => esc_html__( 'Previous', 'warren-core' ),
	'custom_class' => 'qodef-question-next',
	'custom_attrs' => array(
		'data-quiz-id'     => $quiz_id,
		'data-question-id' => $current_question_id,
		'data-course-id'   => $course_id,
		'data-question'    => $prev_question,
	),
);

$next_params = array(
	'text'         => esc_html__( 'Next', 'warren-core' ),
	'custom_class' => 'qodef-question-next',
	'custom_attrs' => array(
		'data-quiz-id'     => $quiz_id,
		'data-question-id' => $current_question_id,
		'data-course-id'   => $course_id,
		'data-question'    => $next_question,
	),
);

$finish_params = array(
	'text'         => esc_html__( 'Finish', 'warren-core' ),
	'custom_class' => 'qodef-quiz-finish',
);
?>
<div class="qodef-e-question">
	<h4 class="qodef-e-question-title">
		<?php echo esc_html( $question_title ); ?>
	</h4>
	<p class="qodef-e-question-description">
		<?php echo esc_html( $question_description ); ?>
	</p>
	<div class="qodef-e-content-holder <?php echo esc_attr( 'qodef--' . $question_type ); ?>">
		<?php
		warren_core_template_part(
			'plugins/lms/post-types/question',
			'templates/parts/post-info/' . $question_type,
			'',
			array(
				'question_id'    => $current_question_id,
				'current_answer' => $current_answer,
				'checked'        => $checked,
			)
		);
		?>
	</div>
	<div class="qodef-e-question-hint"></div>
	<div class="qodef-e-question-action" data-question-id="<?php echo esc_attr( $current_question_id ); ?>" data-quiz-id="<?php echo esc_attr( $quiz_id ); ?>" data-course-id="<?php echo esc_attr( $course_id ); ?>">
		<div class="qodef-row">
			<?php
			echo WarrenCore_Button_Shortcode::call_shortcode( $hint_params );
			echo WarrenCore_Button_Shortcode::call_shortcode( $check_params );
			?>
		</div>
		<div class="qodef-row">
			<?php
			if ( false !== $prev_question ) {
				echo WarrenCore_Button_Shortcode::call_shortcode( $prev_params );
			}

			if ( false !== $next_question ) {
				echo WarrenCore_Button_Shortcode::call_shortcode( $next_params );
			}

			echo WarrenCore_Button_Shortcode::call_shortcode( $finish_params );
			?>
		</div>
	</div>
</div>
