<?php
$answers = get_post_meta( $question_id, 'qodef_question_answers_repeater', true );

$current_answer_array = array();
if ( ! empty( $current_answer ) ) {
	$current_answer = explode( '()', $current_answer );

	if ( is_array( $current_answer ) ) {
		$current_answer_array = $current_answer;
	} else {
		$current_answer_array[] = $current_answer;
	}
}

$classes = array();

if ( 'yes' === $checked ) {
	$classes[] = 'qodef--disable';
}
if ( ! empty( $answers ) ) {
	foreach ( $answers as $answer ) {
		$checked_answer = '';
		if ( in_array( $answer['qodef_question_answer_text'], $current_answer_array, true ) ) {
			$checked_answer = 'checked';
		}
		?>
		<div class="qodef-e-question-checkbox">
			<label <?php qode_framework_class_attribute( $classes ); ?>>
				<input type="checkbox" name="question_answer[]" value="<?php echo esc_attr( $answer['qodef_question_answer_text'] ); ?>" <?php echo esc_attr( $checked_answer ); ?>>
				<?php echo esc_html( $answer['qodef_question_answer_text'] ); ?>
			</label>
		</div>
		<?php
	}
}
?>
