<?php

if ( ! function_exists( 'warren_core_register_quiz_for_meta_options' ) ) {
	function warren_core_register_quiz_for_meta_options( $post_types ) {
		$post_types[] = 'quiz';

		return $post_types;
	}

	add_filter( 'qode_framework_filter_meta_box_save', 'warren_core_register_quiz_for_meta_options' );
	add_filter( 'qode_framework_filter_meta_box_remove', 'warren_core_register_quiz_for_meta_options' );
}

if ( ! function_exists( 'warren_core_add_quiz_custom_post_type' ) ) {
	/**
	 * Function that adds custom post type
	 *
	 * @param array $cpts
	 *
	 * @return array
	 */
	function warren_core_add_quiz_custom_post_type( $cpts ) {
		$cpts[] = 'WarrenCore_Quiz_CPT';

		return $cpts;
	}

	add_filter( 'warren_core_filter_register_custom_post_types', 'warren_core_add_quiz_custom_post_type' );
}

if ( class_exists( 'QodeFrameworkCustomPostType' ) ) {
	class WarrenCore_Quiz_CPT extends QodeFrameworkCustomPostType {

		public function map_post_type() {
			$name = esc_html__( 'Quiz', 'warren-core' );
			$this->set_base( 'quiz' );
			$this->set_menu_position( 5 );
			$this->set_menu_icon( 'dashicons-editor-help' );
			$this->set_slug( 'quiz' );
			$this->set_name( $name );
			$this->set_path( WARREN_CORE_PLUGINS_PATH . '/lms/post-types/quiz' );
			$this->set_labels(
				array(
					'name'          => esc_html__( 'Warren Quiz', 'warren-core' ),
					'singular_name' => esc_html__( 'Quiz', 'warren-core' ),
					'add_item'      => esc_html__( 'New Quiz', 'warren-core' ),
					'add_new_item'  => esc_html__( 'Add New Quiz', 'warren-core' ),
					'edit_item'     => esc_html__( 'Edit Quiz', 'warren-core' ),
				)
			);

			$this->set_supports(
				array(
					'author',
					'title',
					'editor',
					'page-attributes',
				)
			);

			$this->set_public( false );
			$this->set_archive( false );
		}
	}
}
