<?php

if ( ! function_exists( 'warren_core_add_quiz_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_quiz_meta_box() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'  => array( 'quiz' ),
				'type'   => 'meta',
				'slug'   => 'quiz',
				'title'  => esc_html__( 'Quiz Section', 'warren-core' ),
				'layout' => 'tabbed',
			)
		);

		if ( $page ) {

			$general_tab = $page->add_tab_element(
				array(
					'name'  => 'tab-general',
					'icon'  => 'fa fa-cog',
					'title' => esc_html__( 'General', 'warren-core' ),
				)
			);

			$duration_row = $general_tab->add_row_element(
				array(
					'name' => 'qodef_quiz_duration_row',
				)
			);

			$duration_row->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_quiz_duration',
					'title'      => esc_html__( 'Quiz Duration', 'warren-core' ),
					'args'       => array(
						'col_width' => 6,
					),
				)
			);

			$duration_row->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_quiz_duration_unit',
					'title'         => esc_html__( 'Quiz Duration Unit', 'warren-core' ),
					'options'       => array(
						'seconds' => esc_html__( 'Seconds', 'warren-core' ),
						'minutes' => esc_html__( 'Minutes', 'warren-core' ),
						'hours'   => esc_html__( 'Hours', 'warren-core' ),
					),
					'default_value' => 'minutes',
					'args'          => array(
						'col_width' => 6,
					),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_quiz_retakes_number',
					'title'       => esc_html__( 'Number of Retakes', 'warren-core' ),
					'description' => esc_html__( 'Set allowed number of quiz retakes', 'warren-core' ),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_quiz_passing_percentage',
					'title'       => esc_html__( 'Passing Percentage', 'warren-core' ),
					'description' => esc_html__( 'Set percentage required to pass the quiz', 'warren-core' ),
					'args'        => array(
						'suffix' => '%',
					),
				)
			);

			$general_tab->add_field_element(
				array(
					'field_type'  => 'textarea',
					'name'        => 'qodef_quiz_completed_message',
					'title'       => esc_html__( 'Quiz Completed Message', 'warren-core' ),
					'description' => esc_html__( 'Enter message that will be displayed after the quiz is completed', 'warren-core' ),
				)
			);

			$questions_tab = $page->add_tab_element(
				array(
					'name'  => 'tab-questions',
					'icon'  => 'fa fa-cog',
					'title' => esc_html__( 'Questions', 'warren-core' ),
				)
			);

			$questions = qode_framework_get_cpt_items( 'question' );

			$questions_repeater = $questions_tab->add_repeater_element(
				array(
					'field_type' => 'select',
					'name'       => 'qodef_quiz_questions',
					'title'      => esc_html__( 'Quiz Questions', 'warren-core' ),
				)
			);

			$questions_repeater->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_quiz_question',
					'title'       => esc_html__( 'Question', 'warren-core' ),
					'description' => esc_html__( 'Choose question', 'warren-core' ),
					'options'     => $questions,
				)
			);
			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_lesson_meta_box_map', $page );
		}
	}

	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_add_quiz_meta_box', 1 );
}
