<?php
$quiz_id          = isset( $item_id ) ? $item_id : get_the_ID();
$quiz_title       = get_the_title( $quiz_id );
$questions_number = count( get_post_meta( $quiz_id, 'qodef_quiz_questions', true ) );
$retakes          = get_post_meta( $quiz_id, 'qodef_quiz_retakes_number', true );
$quiz_info        = warren_core_get_user_quiz_info( get_current_user_id(), $course_id, $quiz_id );
$questions_label  = $questions_number . esc_html__( ' Questions', 'warren-core' );
$quiz_status      = $quiz_info['status'];
$time_format      = warren_core_course_format_time( $quiz_info['time_left'] );

if ( 1 === $questions_number ) {
	$questions_label = $questions_number . esc_html__( ' Question', 'warren-core' );
}

$button_params = array(
	'text'         => esc_html__( 'Start Quiz', 'warren-core' ),
	'custom_class' => 'qodef-start-quiz',
	'custom_attrs' => array(
		'data-quiz-id'   => $quiz_id,
		'data-course-id' => $course_id,
		'data-question'  => $quiz_info['current_question'],
	),
);

if ( 'started' === $quiz_status ) {
	$button_params['text'] = esc_html__( 'Resume Quiz', 'warren-core' );
} elseif ( 'finished' === $quiz_status ) {
	// translators: %d - added retakes left number
	$button_params['text']                        = sprintf( esc_html__( 'Retake Quiz +%d', 'warren-core' ), intval( $retakes ) - intval( $quiz_info['takes'] ) + 1 );
	$button_params['custom_attrs']['data-retake'] = 'yes';
}
?>
<div class="qodef-item-content qodef--quiz" data-quiz-id="<?php echo esc_attr( $quiz_id ); ?>" data-course-id="<?php echo esc_attr( $course_id ); ?>">
	<h3 class="qodef-e-title">
		<?php echo esc_html( $quiz_title ); ?>
	</h3>
	<div class="qodef-e-info">
		<div class="qodef-e-info-timer" data-time="<?php echo esc_attr( $quiz_info['time_left'] ); ?>"><?php echo esc_html( $time_format ); ?></div>
		<div class="qodef-e-info-questions">
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512" width="20"><path d="M320 64h-49.61C262.1 27.48 230.7 0 192 0S121 27.48 113.6 64H64C28.65 64 0 92.66 0 128v320c0 35.34 28.65 64 64 64h256c35.35 0 64-28.66 64-64V128C384 92.66 355.3 64 320 64zM192 48c13.23 0 24 10.77 24 24S205.2 96 192 96S168 85.23 168 72S178.8 48 192 48zM336 448c0 8.82-7.178 16-16 16H64c-8.822 0-16-7.18-16-16V128c0-8.82 7.178-16 16-16h18.26C80.93 117.1 80 122.4 80 128v16C80 152.8 87.16 160 96 160h192c8.836 0 16-7.164 16-16V128c0-5.559-.9316-10.86-2.264-16H320c8.822 0 16 7.18 16 16V448z"/></svg>
			<span class="qodef-e-info-label"><?php echo esc_html( $questions_label ); ?></span>
		</div>
	</div>
	<div class="qodef-e-content-holder">
		<div class="qodef-e-content">
			<?php
			if ( qode_framework_is_installed( 'elementor' ) && warren_core_get_elementor_instance()->documents->get( $quiz_id )->is_built_with_elementor() ) {
				echo warren_core_get_elementor_instance()->frontend->get_builder_content( $quiz_id, true );
			} else {
				echo wp_kses_post( str_replace( ']]>', ']]&gt;', apply_filters( 'the_content', get_the_content( null, false, $quiz_id ) ) ) );
			}

			if ( $quiz_info['takes'] > $retakes ) {
				esc_html_e( 'Sorry, you have exceeded retakes limit.', 'warren-core' );
			} else {
				echo WarrenCore_Button_Shortcode::call_shortcode( $button_params );
			}
			?>
		</div>
	</div>
</div>
