<?php

if ( ! function_exists( 'warren_core_add_listing_roles_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_listing_roles_options( $page ) {

		$page->add_field_element(
			array(
				'field_type'    => 'yesno',
				'name'          => 'qodef_listing_registration_role',
				'title'         => esc_html__( 'Enable Registration Role', 'warren-core' ),
				'description'   => esc_html__( 'Enable this if you want to allow users to choose role upon registration. Otherwise, default role from WP Settings -> General will be used.', 'warren-core' ),
				'default_value' => 'yes',
			)
		);

		$page->add_field_element(
			array(
				'field_type'    => 'yesno',
				'name'          => 'qodef_listing_enable_owner_role',
				'title'         => esc_html__( 'Enable Owner Role', 'warren-core' ),
				'default_value' => 'yes',
				'dependency'    => array(
					'show' => array(
						'qodef_listing_registration_role' => array(
							'values'        => 'yes',
							'default_value' => 'yes',
						),
					),
				),
			)
		);

		$page->add_field_element(
			array(
				'field_type'    => 'yesno',
				'name'          => 'qodef_listing_enable_owner_adding_listing',
				'title'         => esc_html__( 'Enable Adding Listing Item for Owner', 'warren-core' ),
				'default_value' => 'yes',
			)
		);

		$page->add_field_element(
			array(
				'field_type'    => 'yesno',
				'name'          => 'qodef_listing_enable_owner_publish_listing',
				'title'         => esc_html__( 'Enable Publishing Listing Item for Owner', 'warren-core' ),
				'default_value' => 'yes',
			)
		);
	}

	add_action( 'warren_core_action_after_enable_package_feature_options_map', 'warren_core_add_listing_roles_options' );
}
