<?php

if ( ! function_exists( 'warren_core_add_user_instructor_role' ) ) {
	function warren_core_add_user_instructor_role() {
		$allowed_type = 'course';

		$capabilities = array(
			'read'                                  => false,
			'read_private' . $allowed_type . 's'    => false,
			'publish_' . $allowed_type . 's'        => false,
			'edit_' . $allowed_type . 's'           => false,
			'edit_published_' . $allowed_type . 's' => false,
			'edit_others_' . $allowed_type . 's'    => false,
			'edit_pages'                            => false,
			'manage_categories'                     => false,
			'manage_terms'                          => false,
			'edit_themes'                           => false,
			'install_plugins'                       => false,
			'update_plugin'                         => false,
			'edit_plugins'                          => false,
			'update_core'                           => false,
			'upload_files'                          => true,
			'edit_files'                            => false,
		);

		add_role( 'instructor', esc_html__( 'Instructor', 'warren-core' ), $capabilities );
	}

	add_action( 'warren_core_action_plugin_loaded', 'warren_core_add_user_instructor_role' );
}
