<?php

if ( ! function_exists( 'warren_core_add_instructor_user_options' ) ) {
	function warren_core_add_instructor_user_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope' => array( 'instructor' ),
				'type'  => 'user',
				'title' => esc_html__( 'Instructor Info', 'warren-core' ),
				'slug'  => 'owner-options',
			)
		);

		if ( $page ) {
			$page->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_instructor_profile_image',
					'title'      => esc_html__( 'Profile Image', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_occupation',
					'title'      => esc_html__( 'Occupation', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_telephone',
					'title'      => esc_html__( 'Telephone', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_mobile_phone',
					'title'      => esc_html__( 'Mobile Phone', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_fax_number',
					'title'      => esc_html__( 'Fax Number', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_address',
					'title'      => esc_html__( 'Instructor Address', 'warren-core' ),
				)
			);
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_role',
					'title'      => esc_html__( 'Instructor Role', 'warren-core' ),
				)
			);
		}
	}

	add_action( 'warren_core_action_register_role_custom_fields', 'warren_core_add_instructor_user_options' );
}
