<?php

if ( ! function_exists( 'warren_core_add_instructor_profile_page_content' ) ) {
	function warren_core_add_instructor_profile_page_content( $params ) {

		if ( isset( $params['user'] ) && in_array( 'instructor', $params['user']->roles, true ) ) {
			warren_core_template_part( 'plugins/lms/roles/instructor', 'templates/profile', 'additional', $params );
		}
	}

	add_action( 'warren_membership_action_additional_profile_page_content', 'warren_core_add_instructor_profile_page_content' );
}

if ( ! function_exists( 'warren_core_get_instructor_params' ) ) {
	/**
	 * Returns owner params
	 */
	function warren_core_get_instructor_params( $params ) {

		if ( in_array( 'instructor', $params['user']->roles, true ) ) {
			$user_id = $params['user']->data->ID;

			$params['about_me']                 = get_user_meta( $user_id, 'qodef_instructor_about_me', true );
			$params['occupation']               = get_user_meta( $user_id, 'qodef_instructor_occupation', true );
			$params['telephone']                = get_user_meta( $user_id, 'qodef_instructor_telephone', true );
			$params['mobile_phone']             = get_user_meta( $user_id, 'qodef_instructor_mobile_phone', true );
			$params['fax_number']               = get_user_meta( $user_id, 'qodef_instructor_fax_number', true );
			$params['address']                  = get_user_meta( $user_id, 'qodef_instructor_address', true );
			$params['role']                  = get_user_meta( $user_id, 'qodef_instructor_role', true );
			$params['education']                = get_user_meta( $user_id, 'qodef_instructor_education', true );
			$params['instructor_profile_image'] = get_user_meta( $user_id, 'qodef_instructor_profile_image', true );

			if ( isset( $params['instructor_profile_image'] ) && '' !== $params['instructor_profile_image'] ) {
				$params['profile_image'] = wp_get_attachment_image( $params['instructor_profile_image'], 'medium' );
			}
		}

		return $params;
	}

	add_filter( 'warren_membership_filter_user_params', 'warren_core_get_instructor_params' );
}

if ( ! function_exists( 'warren_core_instructor_edit_profile_fields' ) ) {
	function warren_core_instructor_edit_profile_fields( $page, $params ) {
		if ( in_array( 'instructor', $params['user']->roles, true ) ) {
			extract( $params ); // @codingStandardsIgnoreLine

			$page->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_instructor_profile_image',
					'title'      => esc_html__( 'Profile Image', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'textarea',
					'name'       => 'qodef_instructor_about_me',
					'title'      => esc_html__( 'About Me', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type'  => 'file',
					'name'        => 'qodef_instructor_cv',
					'title'       => esc_html__( 'Upload CV', 'warren-core' ),
					'description' => esc_html__( 'Upload your cv in pdf format', 'warren-core' ),
					'args'        => array(
						'allowed_type' => 'application/pdf',
					),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_occupation',
					'title'      => esc_html__( 'Occupation', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'type'       => 'user',
					'field_type' => 'text',
					'name'       => 'qodef_instructor_telephone',
					'title'      => esc_html__( 'Telephone', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_mobile_phone',
					'title'      => esc_html__( 'Mobile Phone', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_fax_number',
					'title'      => esc_html__( 'Fax Number', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_address',
					'title'      => esc_html__( 'Address', 'warren-core' ),
				)
			);
			$page->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_role',
					'title'      => esc_html__( 'Instructor Role', 'warren-core' ),
				)
			);

			$education = $page->add_repeater_element(
				array(
					'name'  => 'qodef_instructor_education',
					'title' => esc_html__( 'Education', 'warren-core' ),
				)
			);

			$education->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_education_title',
					'title'      => esc_html__( 'Title', 'warren-core' ),
				)
			);

			$education->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_education_description',
					'title'      => esc_html__( 'Description', 'warren-core' ),
				)
			);

			$experience = $page->add_repeater_element(
				array(
					'name'  => 'qodef_instructor_experience',
					'title' => esc_html__( 'Experience', 'warren-core' ),
				)
			);

			$experience->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_experience_title',
					'title'      => esc_html__( 'Title', 'warren-core' ),
				)
			);

			$experience->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_instructor_experience_description',
					'title'      => esc_html__( 'Description', 'warren-core' ),
				)
			);

			$page->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_instructor_diplomas',
					'title'      => esc_html__( 'Diplomas/Certificates', 'warren-core' ),
					'multiple'   => 'yes',
				)
			);
		}
	}

	add_action( 'warren_membership_action_after_dashboard_edit_profile_fields', 'warren_core_instructor_edit_profile_fields', 10, 2 );
}

if ( ! function_exists( 'warren_core_instructor_update' ) ) {
	/**
	 * Function that update user meta fields for main dashboard page
	 *
	 * @param array $options
	 * @param int $user_id
	 */
	function warren_core_instructor_update( $options, $user_id ) {
		$user_meta  = get_userdata( $user_id );
		$user_roles = $user_meta->roles;

		if ( in_array( 'instructor', $user_roles, true ) ) {

			update_user_meta( $user_id, 'qodef_instructor_profile_image', $options['qodef_instructor_profile_image'] );
			update_user_meta( $user_id, 'qodef_instructor_about_me', $options['qodef_instructor_about_me'] );
			update_user_meta( $user_id, 'qodef_instructor_cv', $options['qodef_instructor_cv'] );
			update_user_meta( $user_id, 'qodef_instructor_occupation', $options['qodef_instructor_occupation'] );
			update_user_meta( $user_id, 'qodef_instructor_telephone', $options['qodef_instructor_telephone'] );
			update_user_meta( $user_id, 'qodef_instructor_mobile_phone', $options['qodef_instructor_mobile_phone'] );
			update_user_meta( $user_id, 'qodef_instructor_fax_number', $options['qodef_instructor_fax_number'] );
			update_user_meta( $user_id, 'qodef_instructor_address', $options['qodef_instructor_address'] );
			update_user_meta( $user_id, 'qodef_instructor_role', $options['qodef_instructor_role'] );
			if ( ! empty( $options['qodef_instructor_education'] ) ) {
				update_user_meta( $user_id, 'qodef_instructor_education', $options['qodef_instructor_education'] );
			}
			if ( ! empty( $options['qodef_instructor_experience'] ) ) {
				update_user_meta( $user_id, 'qodef_instructor_experience', $options['qodef_instructor_experience'] );
			}
			update_user_meta( $user_id, 'qodef_instructor_diplomas', $options['qodef_instructor_diplomas'] );
		}
	}

	add_action( 'warren_membership_action_update_user_profile', 'warren_core_instructor_update', 10, 2 );
}

if ( ! function_exists( 'warren_core_instructor_limit_access_attachments' ) ) {
	function warren_core_instructor_limit_access_attachments( $query ) {
		$user = wp_get_current_user();

		if ( in_array( 'instructor', $user->roles, true ) ) {
			if ( ! current_user_can( 'edit_others_posts' ) ) {
				$query['author'] = $user->ID;
			}
		}

		return $query;
	}

	add_filter( 'ajax_query_attachments_args', 'warren_core_instructor_limit_access_attachments' );
}

if ( ! function_exists( 'warren_core_add_instructor_social' ) ) {
	function warren_core_add_instructor_social( $users ) {
		$users[] = 'instructor';

		return $users;
	}

	add_filter( 'warren_core_filter_role_social_array', 'warren_core_add_instructor_social' );
}

if ( ! function_exists( 'warren_core_instructor_archive_layouts' ) ) {
	function warren_core_instructor_archive_layouts( $blog ) {
		$instructors = warren_core_course_get_instructors();

		//if we are on author page of user who is instructor
		if ( is_author( array_flip( $instructors ) ) ) {
			global $wp_query;

			$params = array();

			$author                      = $wp_query->get_queried_object()->data;
			$params['additional_params'] = 'instructor';
			$params['instructor']        = $author->ID;


			return warren_core_get_template_part( 'plugins/lms/roles/instructor', 'templates/instructor-archive', '', $params );
		}

		return $blog;
	}

	add_filter( 'warren_filter_blog_template', 'warren_core_instructor_archive_layouts' );
}

if ( ! function_exists( 'warren_core_include_instructor_shortcodes' ) ) {
	/**
	 * Function that includes shortcodes
	 */
	function warren_core_include_instructor_shortcodes() {
		foreach ( glob( WARREN_CORE_PLUGINS_PATH . '/lms/roles/instructor/shortcodes/*/include.php' ) as $shortcode ) {
			include_once $shortcode;
		}
	}

	add_action( 'qode_framework_action_before_shortcodes_register', 'warren_core_include_instructor_shortcodes' );
}
