<?php

$instructor_name          = get_user_meta( $instructor, 'first_name', true ) . ' ' . get_user_meta( $instructor, 'last_name', true );
$instructor_bio           = get_user_meta( $instructor, 'description', true );
$author_role              = get_user_meta( $instructor, 'qodef_instructor_role', true );
$user_socials             = warren_core_get_author_social_networks( $instructor );
$instructor_profile_image = get_user_meta( $instructor, 'qodef_instructor_profile_image', true );


if ( '' !== $instructor_profile_image ) {
	$profile_image = wp_get_attachment_image( $instructor_profile_image, 'medium' );
} else {
	$profile_image = get_avatar( $instructor, 120 );
}
?>
<div class="qodef-instructor-info">
	<div class="qodef-m-instructor-image">
		<?php echo wp_kses_post( $profile_image ); ?>
	</div>
	<div class="qodef-m-instructor-content">

		<h4 class="qodef-m-info-name vcard author">
			<?php echo esc_html( $instructor_name ); ?>
		</h4>
		<p class="qodef-e-role"><?php echo esc_html( $author_role ); ?></p>
		<?php if ( ! empty( $instructor_bio ) ) { ?>
			<p itemprop="description" class="qodef-m-info-description"><?php echo esc_html( $instructor_bio ); ?></p>
		<?php } ?>
		<?php if ( ! empty( $user_socials ) ) { ?>
			<div class="qodef-m-social-icons">
				<?php foreach ( $user_socials as $social ) { ?>
					<a itemprop="url" class="<?php echo esc_attr( $social['class'] ); ?>"
					   href="<?php echo esc_url( $social['url'] ); ?>" target="_blank">
						<?php //echo esc_attr( $social['text'] ); ?>
						<?php
						// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo warren_core_get_svg_icon( $social['network'] );
						?>
					</a>
				<?php } ?>
			</div>
		<?php } ?>
	</div>
</div>
