<?php

$instructor_about_me = get_user_meta( $instructor, 'qodef_instructor_about_me', true );
$instructor_cv       = get_user_meta( $instructor, 'qodef_instructor_cv', true );

$button_params = array();

if ( ! empty( $instructor_cv ) ) {

	$button_params = array(
		'custom_class'  => 'qodef-cv-button',
		'button_layout' => 'textual',
		'link'          => wp_get_attachment_url( $instructor_cv ),
		'text'          => esc_html__( 'Download', 'warren-core' ),
		'custom_attrs'  => array(
			'download' => esc_html__( 'CV', 'warren-core' ),
		),
	);
}


?>
<div class="qodef-m-about">
	<h3 class="qodef-m-about-title">
		<?php esc_html_e( 'Hello. This is my story.', 'warren-core' ); ?>
	</h3>
	<?php if ( ! empty( $instructor_about_me ) ) { ?>
		<p class="qodef-m-about-me">
			<?php echo esc_html( $instructor_about_me ); ?>
		</p>
	<?php } ?>
	<?php
	if ( ! empty( $button_params ) ) {
		echo WarrenCore_Button_Shortcode::call_shortcode( $button_params );
	}
	?>
</div>
