<?php

if ( ! class_exists( 'WarrenCore_WooCommerce_YITH_Wishlist' ) ) {
	class WarrenCore_WooCommerce_YITH_Wishlist {
		private static $instance;

		public function __construct() {

			if ( qode_framework_is_installed( 'yith-wishlist' ) ) {
				// Init
				add_action( 'after_setup_theme', array( $this, 'init' ) );
			}
		}

		/**
		 * @return WarrenCore_WooCommerce_YITH_Wishlist
		 */
		public static function get_instance() {
			if ( is_null( self::$instance ) ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		function init() {

			// Change default templates position
			$this->change_templates_position();

			// Disable default resopnsive YITH Wishlist Page Table
			add_filter( 'yith_wcwl_is_wishlist_responsive', array( $this, 'is_responsive' ) );

			// Set plugin options
			add_action( 'init', array( $this, 'set_plugin_options' ), 15 );
		}

		function change_templates_position() {

			// Add button element for shop pages
			add_action( 'warren_action_product_list_item_additional_hover_content', 'warren_core_get_yith_wishlist_shortcode' );
			add_action( 'warren_core_action_product_list_item_additional_hover_content', 'warren_core_get_yith_wishlist_shortcode' );
		}

		function is_responsive() {

			// Prevent from using wp_is_mobile and rendering responsive list instead of regular cart table
			return false;
		}

		function set_plugin_options() {
			$option = 'yes' === warren_core_get_post_value_through_levels( 'qodef_enable_woo_yith_wishlist_predefined_style', );

			if ( $option ) {
				update_option( 'yith_wcwl_price_show', 'yes' );
				update_option( 'yith_wcwl_stock_show', 'yes' );
				// update_option( 'yith_wcwl_show_dateadded', 'no' );
				update_option( 'yith_wcwl_add_to_cart_show', 'yes' );
				update_option( 'yith_wcwl_show_remove', 'yes' );
				// update_option( 'yith_wcwl_variation_show', 'no' );
				// update_option( 'yith_wcwl_repeat_remove_button', 'no' );
			}
		}
	}

	WarrenCore_WooCommerce_YITH_Wishlist::get_instance();
}
