<?php

if ( ! function_exists( 'warren_core_add_event_options' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_event_options() {
		$qode_framework = qode_framework_get_framework_root();

		$page = $qode_framework->add_options_page(
			array(
				'scope'       => WARREN_CORE_OPTIONS_NAME,
				'type'        => 'admin',
				'slug'        => 'event-item',
				'icon'        => 'fa fa-cog',
				'title'       => esc_html__( 'Event', 'warren-core' ),
				'description' => esc_html__( 'Global settings related to event', 'warren-core' )
			)
		);
		
		if ( $page ) {

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_event_enable_navigation',
					'title'         => esc_html__( 'Navigation', 'warren-core' ),
					'description'   => esc_html__( 'Enabling this option will turn on event navigation functionality', 'warren-core' ),
					'default_value' => 'yes'
				)
			);

			$page->add_field_element(
				array(
					'field_type'    => 'yesno',
					'name'          => 'qodef_event_navigation_through_same_category',
					'title'         => esc_html__( 'Pagination Through Same Category', 'warren-core' ),
					'description'   => esc_html__( 'Enabling this option will make event navigation sort through current category', 'warren-core' ),
					'default_value' => 'no',
					'dependency'    => array(
						'show' => array(
							'qodef_show_event_navigation' => array(
								'values'        => 'yes',
								'default_value' => 'yes'
							)
						)
					)
				)
			);


			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_event_options_map', $page );
		}
	}
	
	add_action( 'warren_core_action_default_options_init', 'warren_core_add_event_options', warren_core_get_admin_options_map_position( 'event' ) );
}
