<?php
$is_enabled = warren_core_get_post_value_through_levels( 'qodef_event_enable_navigation' );

if ( $is_enabled === 'yes' ) {
	$through_same_category = warren_core_get_post_value_through_levels( 'qodef_event_navigation_through_same_category' ) === 'yes';
	?>
	<div id="qodef-single-event-navigation" class="qodef-m">
		<div class="qodef-m-inner">
			<?php

			$post_navigation = array(
				'prev' => array(
					'label' => '<span class="qodef-m-nav-label">' . esc_html__( 'Previous', 'warren-core' ) . '</span>',
					'icon'  => warren_core_get_svg_icon( 'pagination-post-arrow-left', 'qodef-m-pagination-icon' ),
				),
				'next' => array(
					'label' => '<span class="qodef-m-nav-label">' . esc_html__( 'Next', 'warren-core' ) . '</span>',
					'icon'  => warren_core_get_svg_icon( 'pagination-post-arrow-right', 'qodef-m-pagination-icon' ),
				),
			);

			if ( $through_same_category ) {
				if ( get_adjacent_post( true, '', true, 'event-category' ) !== '' ) {
					$post_navigation['prev']['post'] = get_adjacent_post( true, '', true, 'event-category' );
				}
				if ( get_adjacent_post( true, '', false, 'event-category' ) !== '' ) {
					$post_navigation['next']['post'] = get_adjacent_post( true, '', false, 'event-category' );
				}
			} else {
				if ( get_adjacent_post( false, '', true ) !== '' ) {
					$post_navigation['prev']['post'] = get_adjacent_post( false, '', true );
				}
				if ( get_adjacent_post( false, '', false ) !== '' ) {
					$post_navigation['next']['post'] = get_adjacent_post( false, '', false );
				}
			}
			foreach ( $post_navigation as $key => $value ) {
				if ( isset( $post_navigation[ $key ]['post'] ) ) {
					$current_post = $value['post'];
					$post_id      = $current_post->ID;
					?>
					<a itemprop="url" class="qodef-m-nav qodef--<?php echo esc_attr( $key ); ?>" href="<?php echo get_permalink( $post_id ); ?>">
							<?php echo qode_framework_wp_kses_html( 'svg', $value['icon'] ); ?>
						<?php echo wp_kses( $value['label'], array( 'span' => array( 'class' => true ) ) ); ?>
					</a>
				<?php }
			}
			?>
		</div>
	</div>
<?php } ?>