<?php

if ( ! function_exists( 'warren_core_register_podcast_for_meta_options' ) ) {
	/**
	 * Function that add custom post type into global meta box allowed items array for saving meta box options
	 *
	 * @param array $post_types
	 *
	 * @return array
	 */
	function warren_core_register_podcast_for_meta_options( $post_types ) {
		$post_types[] = 'podcast-item';

		return $post_types;
	}

	add_filter( 'qode_framework_filter_meta_box_save', 'warren_core_register_podcast_for_meta_options' );
	add_filter( 'qode_framework_filter_meta_box_remove', 'warren_core_register_podcast_for_meta_options' );
}

if ( ! function_exists( 'warren_core_add_podcast_custom_post_type' ) ) {
	/**
	 * Function that adds podcast custom post type
	 *
	 * @param array $cpts
	 *
	 * @return array
	 */
	function warren_core_add_podcast_custom_post_type( $cpts ) {
		$cpts[] = 'WarrenCore_Podcast_CPT';

		return $cpts;
	}

	add_filter( 'warren_core_filter_register_custom_post_types', 'warren_core_add_podcast_custom_post_type' );
}

if ( class_exists( 'QodeFrameworkCustomPostType' ) ) {
	class WarrenCore_Podcast_CPT extends QodeFrameworkCustomPostType {

		public function map_post_type() {
			$name = esc_html__( 'Podcast', 'warren-core' );
			$this->set_base( 'podcast-item' );
			$this->set_menu_position( 10 );
			$this->set_menu_icon( 'dashicons-microphone' );
			$this->set_slug( 'podcast-item' );
			$this->set_name( $name );
			$this->set_path( WARREN_CORE_CPT_PATH . '/podcast' );
			$this->set_labels(
				array(
					'name'          => esc_html__( 'Warren Podcast', 'warren-core' ),
					'singular_name' => esc_html__( 'Podcast Item', 'warren-core' ),
					'add_item'      => esc_html__( 'New Podcast Item', 'warren-core' ),
					'add_new_item'  => esc_html__( 'Add New Podcast Item', 'warren-core' ),
					'edit_item'     => esc_html__( 'Edit Podcast Item', 'warren-core' )
				)
			);
			$this->add_post_taxonomy(
				array(
					'base'          => 'podcast-category',
					'slug'          => 'podcast-category',
					'singular_name' => esc_html__( 'Category', 'warren-core' ),
					'plural_name'   => esc_html__( 'Categories', 'warren-core' ),
				)
			);
			$this->add_post_taxonomy(
				array(
					'base'          => 'podcast-tag',
					'slug'          => 'podcast-tag',
					'singular_name' => esc_html__( 'Tag', 'warren-core' ),
					'plural_name'   => esc_html__( 'Tags', 'warren-core' ),
				)
			);
		}
	}
}