<?php

if ( ! function_exists( 'warren_core_add_podcast_archive_list_options' ) ) {
	/**
	 * Function that add list options for podcast archive module
	 */
	function warren_core_add_podcast_archive_list_options( $tab ) {
		$list_item_layouts = apply_filters( 'warren_core_filter_podcast_list_layouts', array() );
		$options_map       = warren_core_get_variations_options_map( $list_item_layouts );

		if ( $tab ) {
			$tab->add_field_element( array(
				'field_type'    => 'select',
				'name'          => 'qodef_podcast_archive_item_layout',
				'title'         => esc_html__( 'Item Layout', 'warren-core' ),
				'description'   => esc_html__( 'Choose layout for list item on archive lists', 'warren-core' ),
				'options'       => $list_item_layouts,
				'default_value' => $options_map['default_value']
			) );
			$tab->add_field_element( array(
				'field_type'  => 'select',
				'name'        => 'qodef_podcast_archive_columns',
				'title'       => esc_html__( 'Number of Columns', 'warren-core' ),
				'description' => esc_html__( 'Choose number of columns for archive lists', 'warren-core' ),
				'options'     => warren_core_get_select_type_options_pool( 'columns_number' )
			) );
			$tab->add_field_element( array(
				'field_type'  => 'select',
				'name'        => 'qodef_podcast_archive_space',
				'title'       => esc_html__( 'Space Between Items', 'warren-core' ),
				'description' => esc_html__( 'Choose space between items for archive lists', 'warren-core' ),
				'options'     => warren_core_get_select_type_options_pool( 'items_space' )
			) );
		}
	}

	add_action( 'warren_core_action_after_podcast_options_archive', 'warren_core_add_podcast_archive_list_options' );
}
