<?php

if ( ! function_exists( 'warren_core_add_podcast_single_meta_box' ) ) {
	/**
	 * Function that add general options for this module
	 */
	function warren_core_add_podcast_single_meta_box() {
		$qode_framework = qode_framework_get_framework_root();
		
		$page = $qode_framework->add_options_page(
			array(
				'scope'  => array( 'podcast-item' ),
				'type'   => 'meta',
				'slug'   => 'podcast-item',
				'title'  => esc_html__( 'Podcast Settings', 'warren-core' ),
				'layout' => 'tabbed'
			)
		);
		
		if ( $page ) {
			
			$general_tab = $page->add_tab_element(
				array(
					'name'        => 'tab-general',
					'icon'        => 'fa fa-cog',
					'title'       => esc_html__( 'General Settings', 'warren-core' ),
					'description' => esc_html__( 'General podcast settings', 'warren-core' )
				)
			);

			$section_media = $general_tab->add_section_element(
				array(
					'name'        => 'qodef_podcast_media_section',
					'title'       => esc_html__( 'Media', 'warren-core' ),
				)
			);

			$section_media->add_field_element(
				array(
					'field_type' => 'file',
					'name'       => 'qodef_podcast_file',
					'title'      => esc_html__( 'Podcast Audio File (mp3)', 'warren-core' ),
					'args'       => array(
						'allowed_type' => '[audio/mpeg]'
					)
				)
			);

			$section_parts = $general_tab->add_section_element(
				array(
					'name'        => 'qodef_podcast_parts_section',
					'title'       => esc_html__( 'Parts Settings', 'warren-core' ),
				)
			);

			$section_parts->add_field_element(
				array(
					'field_type' => 'image',
					'name'       => 'qodef_podcast_parts_image',
					'title'      => esc_html__( 'Parts Section Image', 'warren-core' ),
				)
			);

			$parts_items_repeater = $section_parts->add_repeater_element(
				array(
					'name'        => 'qodef_podcast_parts_items',
					'title'       => esc_html__( 'Parts Items', 'warren-core' ),
					'button_text' => esc_html__( 'Add Item', 'warren-core' )
				)
			);

			$parts_items_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_part_item_label',
					'title'      => esc_html__( 'Item Label', 'warren-core' )
				)
			);

			$parts_items_repeater->add_field_element(
				array(
					'field_type' => 'text',
					'name'       => 'qodef_part_item_value',
					'title'      => esc_html__( 'Item Time', 'warren-core' )
				)
			);
			
			// Hook to include additional options after module options
			do_action( 'warren_core_action_after_podcast_meta_box_map', $page, $general_tab );
		}
	}
	
	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_add_podcast_single_meta_box' );
}

if ( ! function_exists( 'warren_core_include_general_meta_boxes_for_podcast_single' ) ) {
	/**
	 * Function that add general meta box options for this module
	 */
	function warren_core_include_general_meta_boxes_for_podcast_single() {
		$callbacks = warren_core_general_meta_box_callbacks();
		
		if ( ! empty( $callbacks ) ) {
			foreach ( $callbacks as $module => $callback ) {

				if ( 'page-sidebar' !== $module ) {
					add_action( 'warren_core_action_after_podcast_meta_box_map', $callback );
				}
			}
		}
	}
	
	add_action( 'warren_core_action_default_meta_boxes_init', 'warren_core_include_general_meta_boxes_for_podcast_single', 8 ); // Permission 8 is set in order to load it before default meta box function
}
