<?php

if ( ! function_exists( 'warren_core_get_podcast_holder_classes' ) ) {
	/**
	 * Function that return classes for the main podcast holder
	 *
	 * @return string
	 */
	function warren_core_get_podcast_holder_classes() {
		$classes = array( 'qodef-podcast-single' );

		return implode( ' ', $classes );
	}
}

if ( ! function_exists( 'warren_core_generate_podcast_archive_with_shortcode' ) ) {
	/**
	 * Function that executes podcast list shortcode with params on archive pages
	 *
	 * @param string $tax - type of taxonomy
	 * @param string $tax_slug - slug of taxonomy
	 */
	function warren_core_generate_podcast_archive_with_shortcode( $tax, $tax_slug ) {
		$params = array();

		$params['additional_params'] = 'tax';
		$params['tax']               = $tax;
		$params['tax_slug']          = $tax_slug;
		$params['layout']            = warren_core_get_post_value_through_levels( 'qodef_podcast_archive_item_layout' );
		$params['behavior']          = 'columns';
		$params['columns']           = warren_core_get_post_value_through_levels( 'qodef_podcast_archive_columns' );
		$params['space']             = warren_core_get_post_value_through_levels( 'qodef_podcast_archive_space' );

		echo WarrenCore_Podcast_List_Shortcode::call_shortcode( $params );
	}
}

if ( ! function_exists( 'warren_core_set_podcast_custom_sidebar_name' ) ) {
	/**
	 * Function that return sidebar name
	 *
	 * @param string $sidebar_name
	 *
	 * @return string
	 */
	function warren_core_set_podcast_custom_sidebar_name( $sidebar_name ) {

		if ( is_singular( 'podcast-item' ) ) {
			$option = warren_core_get_post_value_through_levels( 'qodef_podcast_single_custom_sidebar' );
		} elseif ( is_tax() ) {
			$taxonomies = get_object_taxonomies( 'podcast-item' );

			foreach ( $taxonomies as $tax ) {
				if ( is_tax( $tax ) ) {
					$option = warren_core_get_post_value_through_levels( 'qodef_podcast_archive_custom_sidebar' );
				}
			}
		}

		if ( isset( $option ) && ! empty( $option ) ) {
			$sidebar_name = $option;
		}

		return $sidebar_name;
	}

	add_filter( 'warren_filter_sidebar_name', 'warren_core_set_podcast_custom_sidebar_name' );
}

if ( ! function_exists( 'warren_core_set_podcast_sidebar_layout' ) ) {
	/**
	 * Function that return sidebar layout
	 *
	 * @param string $layout
	 *
	 * @return string
	 */
	function warren_core_set_podcast_sidebar_layout( $layout ) {

		if ( is_singular( 'podcast-item' ) ) {
			$option = warren_core_get_post_value_through_levels( 'qodef_podcast_single_sidebar_layout' );
		} elseif ( is_tax() ) {
			$taxonomies = get_object_taxonomies( 'podcast-item' );
			foreach ( $taxonomies as $tax ) {
				if ( is_tax( $tax ) ) {
					$option = warren_core_get_post_value_through_levels( 'qodef_podcast_archive_sidebar_layout' );
				}
			}
		}

		if ( isset( $option ) && ! empty( $option ) ) {
			$layout = $option;
		}

		return $layout;
	}

	add_filter( 'warren_filter_sidebar_layout', 'warren_core_set_podcast_sidebar_layout' );
}

if ( ! function_exists( 'warren_core_set_podcast_sidebar_grid_gutter_classes' ) ) {
	/**
	 * Function that returns grid gutter classes
	 *
	 * @param string $classes
	 *
	 * @return string
	 */
	function warren_core_set_podcast_sidebar_grid_gutter_classes( $classes ) {

		if ( is_singular( 'podcast-item' ) ) {
			$option = warren_core_get_post_value_through_levels( 'qodef_podcast_single_sidebar_grid_gutter' );
		} elseif ( is_tax() ) {
			$taxonomies = get_object_taxonomies( 'podcast-item' );
			foreach ( $taxonomies as $tax ) {
				if ( is_tax( $tax ) ) {
					$option = warren_core_get_post_value_through_levels( 'qodef_podcast_archive_sidebar_grid_gutter' );
				}
			}
		}
		if ( isset( $option ) && ! empty( $option ) ) {
			$classes = 'qodef-gutter--' . esc_attr( $option );
		}

		return $classes;
	}

	add_filter( 'warren_core_filter_grid_gutter_classes', 'warren_core_set_podcast_sidebar_grid_gutter_classes' );
}

if ( ! function_exists( 'warren_core_podcast_set_admin_options_map_position' ) ) {
	/**
	 * Function that set dashboard admin options map position for this module
	 *
	 * @param int $position
	 * @param string $map
	 *
	 * @return int
	 */
	function warren_core_podcast_set_admin_options_map_position( $position, $map ) {

		if ( $map === 'podcast' ) {
			$position = 50;
		}

		return $position;
	}

	add_filter( 'warren_core_filter_admin_options_map_position', 'warren_core_podcast_set_admin_options_map_position', 10, 2 );
}

if ( ! function_exists( 'warren_core_get_podcast_single_post_taxonomies' ) ) {
	/**
	 * Function that return single post taxonomies list
	 *
	 * @param int $post_id
	 *
	 * @return array
	 */
	function warren_core_get_podcast_single_post_taxonomies( $post_id ) {
		$options = array();

		if ( ! empty( $post_id ) ) {
			$options['podcast-tag']      = wp_get_post_terms( $post_id, 'podcast-tag' );
			$options['podcast-category'] = wp_get_post_terms( $post_id, 'podcast-category' );
		}

		return $options;
	}
}

if ( ! function_exists( 'warren_core_include_podcast_single_scripts' ) ) {
	/**
	 * Enqueue 3rd party scripts for current module single page
	 */
	function warren_core_include_podcast_single_scripts() {
		wp_enqueue_script( 'mediaelement-player', WARREN_CORE_CPT_URL_PATH . '/podcast/assets/js/plugins/mediaelement-and-player.js', array( 'jquery' ), false, true );
		wp_enqueue_script( 'mediaelement-jump-forward', WARREN_CORE_CPT_URL_PATH . '/podcast/assets/js/plugins/mediaelement-jump-forward.js', array( 'jquery' ), false, true );
	}

	add_action( 'warren_core_action_before_main_js', 'warren_core_include_podcast_single_scripts' );
}

if ( ! function_exists( 'warren_core_include_podcast_single_player_template' ) ) {
	/**
	 * Enqueue 3rd party scripts for current module single page
	 */
	function warren_core_include_podcast_single_player_template() {

		if ( is_singular( 'podcast-item' ) ) {
			// Include podcast player
			warren_core_template_part( 'post-types/podcast', 'templates/parts/post-info/player-box' );
		}
	}

	add_action( 'warren_action_before_page_inner', 'warren_core_include_podcast_single_player_template' );
}
