<?php

if ( ! function_exists( 'warren_core_add_podcast_list_shortcode' ) ) {
	/**
	 * Function that isadding shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes - Array of registered shortcodes
	 *
	 * @return array
	 */
	function warren_core_add_podcast_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'WarrenCore_Podcast_List_Shortcode';

		return $shortcodes;
	}

	add_filter( 'warren_core_filter_register_shortcodes', 'warren_core_add_podcast_list_shortcode' );
}

if ( class_exists( 'WarrenCore_List_Shortcode' ) ) {
	class WarrenCore_Podcast_List_Shortcode extends WarrenCore_List_Shortcode {

		public function __construct() {
			$this->set_post_type( 'podcast-item' );
			$this->set_post_type_taxonomy( 'podcast-category' );
			$this->set_post_type_additional_taxonomies( array( 'podcast-tag' ) );
			$this->set_layouts( apply_filters( 'warren_core_filter_podcast_list_layouts', array() ) );
			$this->set_extra_options( apply_filters( 'warren_core_filter_podcast_list_extra_options', array() ) );
			$this->set_hover_animation_options( apply_filters( 'warren_core_filter_podcast_list_hover_animation_options', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( WARREN_CORE_CPT_URL_PATH . '/podcast/shortcodes/podcast-list' );
			$this->set_base( 'warren_core_podcast_list' );
			$this->set_name( esc_html__( 'Podcast List', 'warren-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays list of podcasts', 'warren-core' ) );
			$this->set_category( esc_html__( 'Resonator Core', 'warren-core' ) );
			$this->set_scripts(
				apply_filters( 'warren_core_filter_podcast_list_register_assets', array() )
			);

			$this->set_option( array(
				'field_type' => 'text',
				'name'       => 'custom_class',
				'title'      => esc_html__( 'Custom Class', 'warren-core' )
			) );
			$this->map_list_options( array(
				'exclude_behavior'      => array( 'masonry', 'justified-gallery' ),
				'include_slider_option' => array(
					'slider_centered_slides',
					'split_slider',
				),
			) );
			$this->map_query_options( array( 'post_type' => $this->get_post_type() ) );
			$this->map_layout_options( array(
				'layouts'          => $this->get_layouts(),
				'hover_animations' => $this->get_hover_animation_options(),
				'exclude_option'   => array( 'title_tag', 'text_transform' ),
			) );
			$this->set_option(
				array(
					'field_type' => 'select',
					'name'       => 'skin',
					'title'      => esc_html__( 'Skin', 'warren-core' ),
					'options'    => array(
						''      => esc_html__( 'Default', 'warren-core' ),
						'light' => esc_html__( 'Light', 'warren-core' ),
					),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'hide_media',
					'default_value' => 'yes',
					'title'         => esc_html__( 'Hide Media', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'no_yes', false ),

				)
			);
			$this->map_additional_options();
			$this->map_extra_options();
		}

		public static function call_shortcode( $params ) {
			$html = qode_framework_call_shortcode( 'warren_core_podcast_list', $params );
			$html = str_replace( "\n", '', $html );

			return $html;
		}

		public function load_assets() {
			parent::load_assets();

			do_action( 'warren_core_action_podcast_list_load_assets', $this->get_atts() );
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts = $this->get_atts();

			$atts['post_type']       = $this->get_post_type();
			$atts['taxonomy_filter'] = $this->get_post_type_taxonomy();

			// Additional query args
			$atts['additional_query_args'] = $this->get_additional_query_args( $atts );

			$atts['query_result']   = new \WP_Query( warren_core_get_query_params( $atts ) );
			$atts['holder_classes'] = $this->get_holder_classes( $atts );

			$atts['slider_attr'] = $this->get_slider_data( $atts );
			$atts['data_attr']   = warren_core_get_pagination_data( WARREN_CORE_REL_PATH, 'post-types/podcast/shortcodes', 'podcast-list', 'podcast', $atts );

			$atts['this_shortcode'] = $this;

			return warren_core_get_template_part( 'post-types/podcast/shortcodes/podcast-list', 'templates/content', $atts['behavior'], $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-podcast-list';
			$holder_classes[] = isset( $atts['skin'] ) && ! empty( $atts['skin'] ) ? 'qodef-skin--' . $atts['skin'] : '';
			$holder_classes[] = ! empty( $atts['hide_media'] ) && 'yes' === $atts['hide_media'] ? 'qodef-hide-media--yes' : 'qodef-hide-media--no';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-item-layout--' . $atts['layout'] : '';

			$list_classes   = $this->get_list_classes( $atts );
			$holder_classes = array_merge( $holder_classes, $list_classes );

			return implode( ' ', $holder_classes );
		}

		public function get_item_classes( $atts ) {
			$item_classes = $this->init_item_classes();

			$list_item_classes = $this->get_list_item_classes( $atts );

			$item_classes = array_merge( $item_classes, $list_item_classes );

			return implode( ' ', $item_classes );
		}

		public function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_transform'] ) ) {
				$styles[] = 'text-transform: ' . $atts['text_transform'];
			}

			return $styles;
		}
	}
}
