<?php


if ( '' !== get_the_author_meta( 'description' ) ) {
	$author_id     = get_the_author_meta( 'ID' );
	$author_link   = get_author_posts_url( $author_id );
	$email_enabled = 'yes' === warren_core_get_post_value_through_levels( 'qodef_blog_single_enable_author_info_email' );
	$user_socials  = warren_core_get_author_social_networks( $author_id );
	$user_additional_information = get_the_author_meta( 'qodef_user_additional_information', $author_id );
	?>
	<div id="qodef-author-info" class="qodef-single-podcast-author qodef-content-grid">
		<div class="qodef-m-inner">
			<div class="qodef-m-content">
				<h6 class="qodef-author-subtitle"><?php echo esc_attr__('About', 'warren-core') ?></h6>
				<h3 class="qodef-author-title"><?php echo esc_attr__('Our speaker', 'warren-core') . ' '?><span class="fn"><?php echo esc_html( get_the_author_meta( 'display_name' ) ); ?></span></h3>

				<p itemprop="description" class="qodef-m-description"><?php echo esc_html( strip_tags( get_the_author_meta( 'description' ) ) ); ?></p>
				<?php if ( ! empty( $user_socials ) ) { ?>
					<div class="qodef-m-social-icons">
						<?php foreach ( $user_socials as $social ) { ?>
							<a itemprop="url" class="<?php echo esc_attr( $social['class'] ); ?>" href="<?php echo esc_url( $social['url'] ); ?>" target="_blank">
								<?php // echo esc_attr( $social['text'] ); ?>
								<?php
								// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
								echo warren_core_get_svg_icon( $social['network'] );
								?>
							</a>
						<?php } ?>
					</div>
				<?php } ?>
			</div>
		</div>
		<div class="qodef-m-outer">

			<?php if ( ! empty ( $user_additional_information ) ) { ?>
				<p itemprop="additional-info" class="qodef-author-additional-information"><?php echo wp_kses_post( $user_additional_information ); ?></p>
			<?php } ?>
			<?php if ( $email_enabled && is_email( get_the_author_meta( 'email' ) ) ) { ?>
				<p itemprop="email" class="qodef-m-email"><?php echo sanitize_email( get_the_author_meta( 'email' ) ); ?></p>
			<?php } ?>
		</div>
	</div>
<?php } ?>
