<?php

if ( ! function_exists( 'warren_core_add_portfolio_archive_sidebar_options' ) ) {
	/**
	 * Function that add sidebar options for portfolio archive module
	 */
	function warren_core_add_portfolio_archive_sidebar_options( $tab ) {

		if ( $tab ) {
			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_archive_sidebar_layout',
					'title'         => esc_html__( 'Sidebar Layout', 'warren-core' ),
					'description'   => esc_html__( 'Choose default sidebar layout for portfolio archives', 'warren-core' ),
					'default_value' => 'no-sidebar',
					'options'       => warren_core_get_select_type_options_pool( 'sidebar_layouts', false ),
				)
			);

			$custom_sidebars = warren_core_get_custom_sidebars();
			if ( ! empty( $custom_sidebars ) && count( $custom_sidebars ) > 1 ) {
				$tab->add_field_element(
					array(
						'field_type'  => 'select',
						'name'        => 'qodef_portfolio_archive_custom_sidebar',
						'title'       => esc_html__( 'Custom Sidebar', 'warren-core' ),
						'description' => esc_html__( 'Choose a custom sidebar to display on portfolio archives', 'warren-core' ),
						'options'     => $custom_sidebars,
					)
				);
			}

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_archive_sidebar_grid_gutter',
					'title'       => esc_html__( 'Set Grid Gutter', 'warren-core' ),
					'description' => esc_html__( 'Choose grid gutter size to set space between content and sidebar', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$portfolio_archive_sidebar_grid_gutter_row = $tab->add_row_element(
				array(
					'name'       => 'qodef_portfolio_archive_sidebar_grid_gutter_row',
					'dependency' => array(
						'show' => array(
							'qodef_portfolio_archive_sidebar_grid_gutter' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$portfolio_archive_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_sidebar_grid_gutter_custom',
					'title'       => esc_html__( 'Custom Grid Gutter', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_archive_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_sidebar_grid_gutter_custom_1512',
					'title'       => esc_html__( 'Custom Grid Gutter - 1512', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1512px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_archive_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_sidebar_grid_gutter_custom_1200',
					'title'       => esc_html__( 'Custom Grid Gutter - 1200', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1200px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_archive_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_archive_sidebar_grid_gutter_custom_880',
					'title'       => esc_html__( 'Custom Grid Gutter - 880', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 880px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);
		}
	}

	add_action( 'warren_core_action_after_portfolio_options_archive', 'warren_core_add_portfolio_archive_sidebar_options' );
}

if ( ! function_exists( 'warren_core_add_portfolio_single_sidebar_options' ) ) {
	/**
	 * Function that add sidebar options for portfolio single module
	 */
	function warren_core_add_portfolio_single_sidebar_options( $tab ) {

		if ( $tab ) {
			$tab->add_field_element(
				array(
					'field_type'    => 'select',
					'name'          => 'qodef_portfolio_single_sidebar_layout',
					'title'         => esc_html__( 'Sidebar Layout', 'warren-core' ),
					'description'   => esc_html__( 'Choose default sidebar layout for portfolio singles', 'warren-core' ),
					'default_value' => 'no-sidebar',
					'options'       => warren_core_get_select_type_options_pool( 'sidebar_layouts', false ),
				)
			);

			$custom_sidebars = warren_core_get_custom_sidebars();
			if ( ! empty( $custom_sidebars ) && count( $custom_sidebars ) > 1 ) {
				$tab->add_field_element(
					array(
						'field_type'  => 'select',
						'name'        => 'qodef_portfolio_single_custom_sidebar',
						'title'       => esc_html__( 'Custom Sidebar', 'warren-core' ),
						'description' => esc_html__( 'Choose a custom sidebar to display on portfolio singles', 'warren-core' ),
						'options'     => $custom_sidebars,
					)
				);
			}

			$tab->add_field_element(
				array(
					'field_type'  => 'select',
					'name'        => 'qodef_portfolio_single_sidebar_grid_gutter',
					'title'       => esc_html__( 'Set Grid Gutter', 'warren-core' ),
					'description' => esc_html__( 'Choose grid gutter size to set space between content and sidebar', 'warren-core' ),
					'options'     => warren_core_get_select_type_options_pool( 'items_space' ),
				)
			);

			$portfolio_single_sidebar_grid_gutter_row = $tab->add_row_element(
				array(
					'name'       => 'qodef_portfolio_single_sidebar_grid_gutter_row',
					'dependency' => array(
						'show' => array(
							'qodef_portfolio_single_sidebar_grid_gutter' => array(
								'values'        => 'custom',
								'default_value' => '',
							),
						),
					),
				)
			);

			$portfolio_single_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_single_sidebar_grid_gutter_custom',
					'title'       => esc_html__( 'Custom Grid Gutter', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_single_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_single_sidebar_grid_gutter_custom_1512',
					'title'       => esc_html__( 'Custom Grid Gutter - 1512', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1512px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_single_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_single_sidebar_grid_gutter_custom_1200',
					'title'       => esc_html__( 'Custom Grid Gutter - 1200', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 1200px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);

			$portfolio_single_sidebar_grid_gutter_row->add_field_element(
				array(
					'field_type'  => 'text',
					'name'        => 'qodef_portfolio_single_sidebar_grid_gutter_custom_880',
					'title'       => esc_html__( 'Custom Grid Gutter - 880', 'warren-core' ),
					'description' => esc_html__( 'Enter grid gutter size in pixels for screen size below 880px', 'warren-core' ),
					'args'        => array(
						'col_width' => 3,
					),
				)
			);
		}
	}

	add_action( 'warren_core_action_after_portfolio_options_single', 'warren_core_add_portfolio_single_sidebar_options' );
}
