<?php

if ( ! function_exists( 'warren_core_add_banner_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_core_add_banner_widget( $widgets ) {
		$widgets[] = 'WarrenCore_Banner_Widget';

		return $widgets;
	}

	add_filter( 'warren_core_filter_register_widgets', 'warren_core_add_banner_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenCore_Banner_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$widget_mapped = $this->import_shortcode_options(
				array(
					'shortcode_base' => 'warren_core_banner',
				)
			);
			if ( $widget_mapped ) {
				$this->set_base( 'warren_core_banner' );
				$this->set_name( esc_html__( 'Warren Banner', 'warren-core' ) );
				$this->set_description( esc_html__( 'Add a banner element into widget areas', 'warren-core' ) );
			}
		}

		public function render( $atts ) {
			echo WarrenCore_Banner_Shortcode::call_shortcode( $atts ); // XSS OK
		}
	}
}
