(function ($) {
	'use strict';

	qodefCore.shortcodes.warren_core_image_hotspots = {};

	$(document).ready(
		function () {
			qodefImageHotspots.init();
		}
	);

	$(window).resize(
		function () {
			qodefImageHotspots.init();
		}
	);

	var qodefImageHotspots = {
		init          : function () {
			this.$holder = $('.qodef-image-hotspots');

			if (this.$holder.length) {
				this.$holder.each(
					function () {
						qodefImageHotspots.handleOverflow($(this));
					}
				);
			}
		},
		handleOverflow: function ($holder) {
			const $hotspots = $holder.find('.qodef-hotspot-item');

			if ($hotspots.length) {

				$hotspots.each(
					function () {
						const $thisHotspot = $(this),
							$thisHotspotContent = $thisHotspot.find('.qodef-e-content');

						$thisHotspot.removeClass('qodef--reverse');

						const $holderRight = $holder.offset().left + $holder.outerWidth(),
							$thisHotspotContentRight = $thisHotspotContent.offset().left + $thisHotspotContent.outerWidth();

						if ($holderRight < $thisHotspotContentRight) {
							$thisHotspot.addClass('qodef--reverse');
						}
					}
				);
			}
		},
	};

	qodefCore.shortcodes.warren_core_image_hotspots.qodefImageHotspots = qodefImageHotspots;

})(jQuery);
