<?php

if ( ! function_exists( 'warren_core_add_image_hotspots_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function warren_core_add_image_hotspots_shortcode( $shortcodes ) {
		$shortcodes[] = 'WarrenCore_Image_Hotspots_Shortcode';

		return $shortcodes;
	}

	add_filter( 'warren_core_filter_register_shortcodes', 'warren_core_add_image_hotspots_shortcode' );
}

if ( class_exists( 'WarrenCore_Shortcode' ) ) {
	class WarrenCore_Image_Hotspots_Shortcode extends WarrenCore_Shortcode {
		var $breakpoints = array( 1920, 1368, 1200, 1024, 880 ); // match array in scss file: _image-hotspots-default.scss

		public function __construct() {
			$this->set_layouts( apply_filters( 'warren_core_filter_image_hotspots_layouts', array() ) );

			parent::__construct();
		}

		public function map_shortcode() {
			$this->set_shortcode_path( WARREN_CORE_SHORTCODES_URL_PATH . '/image-hotspots' );
			$this->set_base( 'warren_core_image_hotspots' );
			$this->set_name( esc_html__( 'Image Hotspots', 'warren-core' ) );
			$this->set_description( esc_html__( 'Shortcode that displays image hotspots', 'warren-core' ) );

			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'warren-core' ),
				)
			);

			$options_map = warren_core_get_variations_options_map( $this->get_layouts() );
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'layout',
					'title'         => esc_html__( 'Layout', 'warren-core' ),
					'options'       => $this->get_layouts(),
					'default_value' => $options_map['default_value'],
					'visibility'    => array( 'map_for_page_builder' => $options_map['visibility'] ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'image',
					'name'       => 'image',
					'title'      => esc_html__( 'Image', 'warren-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'h3',
					'group'         => esc_html__( 'Title Style', 'warren-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'warren-core' ),
					'group'      => esc_html__( 'Title Style', 'warren-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'text_color',
					'title'      => esc_html__( 'Text Color', 'warren-core' ),
					'group'      => esc_html__( 'Text Style', 'warren-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'pin_color',
					'title'      => esc_html__( 'Pin Color', 'warren-core' ),
					'group'      => esc_html__( 'Pin Style', 'warren-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'content_background_color',
					'title'      => esc_html__( 'Content Background Color', 'warren-core' ),
					'group'      => esc_html__( 'Content Style', 'warren-core' ),
				)
			);

			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Hotspots', 'warren-core' ),
					'items'      => $this->get_repeater_options(),
				)
			);

			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );
			$atts = $this->get_atts();

			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['title_styles']   = $this->get_title_styles( $atts );
			$atts['text_styles']    = $this->get_text_styles( $atts );
			$atts['pin_styles']     = $this->get_pin_styles( $atts );
			$atts['this_shortcode'] = $this;

			return warren_core_get_template_part( 'shortcodes/image-hotspots', 'templates/image-hotspots', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-image-hotspots';
			$holder_classes[] = ! empty( $atts['layout'] ) ? 'qodef-layout--' . $atts['layout'] : '';

			return implode( ' ', $holder_classes );
		}

		public function get_repeater_options() {
			$options     = array();
			$breakpoints = $this->breakpoints;

			$options[] = array(
				'field_type' => 'text',
				'name'       => 'item_title',
				'title'      => esc_html__( 'Hotspot Title', 'warren-core' ),
			);

			$options[] = array(
				'field_type' => 'text',
				'name'       => 'item_text',
				'title'      => esc_html__( 'Hotspot Text', 'warren-core' ),
			);

			$options[] = array(
				'field_type' => 'text',
				'name'       => 'item_link',
				'title'      => esc_html__( 'Hotspot Link', 'warren-core' ),
			);

			$options[] = array(
				'field_type'    => 'select',
				'name'          => 'item_target',
				'title'         => esc_html__( 'Hotspot Link Target', 'warren-core' ),
				'options'       => warren_core_get_select_type_options_pool( 'link_target' ),
				'default_value' => '_self',
			);

			foreach ( $breakpoints as $breakpoint ) {
				$title_label = $breakpoints[0] === $breakpoint ? esc_html__( 'Hotspot Horizontal Offset', 'warren-core' ) : sprintf( '%s ' . $breakpoint . ' %s', esc_html__( 'Hotspot Horizontal Offset Below', 'warren-core' ), esc_html__( 'px', 'warren-core' ) );
				$options[]   = array(
					'field_type' => 'text',
					'name'       => 'item_horizontal_offset_' . $breakpoint,
					'title'      => $title_label,
				);
			}

			foreach ( $breakpoints as $breakpoint ) {
				$title_label = $breakpoints[0] === $breakpoint ? esc_html__( 'Hotspot Vertical Offset', 'warren-core' ) : sprintf( '%s ' . $breakpoint . ' %s', esc_html__( 'Hotspot Vertical Offset Below', 'warren-core' ), esc_html__( 'px', 'warren-core' ) );
				$options[]   = array(
					'field_type' => 'text',
					'name'       => 'item_vertical_offset_' . $breakpoint,
					'title'      => $title_label,
				);
			}

			return $options;
		}

		public function get_item_styles( $item ) {
			$styles      = array();
			$breakpoints = $this->breakpoints;

			$perent_horizontal_breakpoint = $breakpoints[0];
			$perent_vertical_breakpoint   = $breakpoints[0];
			foreach ( $breakpoints as $breakpoint ) {
				if ( ! empty( $item[ 'item_horizontal_offset_' . $breakpoint ] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item[ 'item_horizontal_offset_' . $breakpoint ] ) ) {
						$styles[] = '--qode-hotspot-left-' . $breakpoint . ':' . $item[ 'item_horizontal_offset_' . $breakpoint ];
					} else {
						$styles[] = '--qode-hotspot-left-' . $breakpoint . ':' . $item[ 'item_horizontal_offset_' . $breakpoint ] . 'px';
					}
					$perent_horizontal_breakpoint = $breakpoint;
				} elseif ( ! empty( $item[ 'item_horizontal_offset_' . $perent_horizontal_breakpoint ] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item[ 'item_horizontal_offset_' . $perent_horizontal_breakpoint ] ) ) {
						$styles[] = '--qode-hotspot-left-' . $breakpoint . ':' . $item[ 'item_horizontal_offset_' . $perent_horizontal_breakpoint ];
					} else {
						$styles[] = '--qode-hotspot-left-' . $breakpoint . ':' . $item[ 'item_horizontal_offset_' . $perent_horizontal_breakpoint ] . 'px';
					}
				} else {
					$styles[] = '--qode-hotspot-left-' . $breakpoint . ':0';
				}

				if ( ! empty( $item[ 'item_vertical_offset_' . $breakpoint ] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item[ 'item_vertical_offset_' . $breakpoint ] ) ) {
						$styles[] = '--qode-hotspot-top-' . $breakpoint . ':' . $item[ 'item_vertical_offset_' . $breakpoint ];
					} else {
						$styles[] = '--qode-hotspot-top-' . $breakpoint . ':' . $item[ 'item_vertical_offset_' . $breakpoint ] . 'px';
					}
					$perent_vertical_breakpoint = $breakpoint;
				} elseif ( ! empty( $item[ 'item_vertical_offset_' . $perent_vertical_breakpoint ] ) ) {
					if ( qode_framework_string_ends_with_space_units( $item[ 'item_vertical_offset_' . $perent_vertical_breakpoint ] ) ) {
						$styles[] = '--qode-hotspot-top-' . $breakpoint . ':' . $item[ 'item_vertical_offset_' . $perent_vertical_breakpoint ];
					} else {
						$styles[] = '--qode-hotspot-top-' . $breakpoint . ':' . $item[ 'item_vertical_offset_' . $perent_vertical_breakpoint ] . 'px';
					}
				} else {
					$styles[] = '--qode-hotspot-top-' . $breakpoint . ':0';
				}
			}

			return $styles;
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			if ( ! empty( $atts['content_background_color'] ) ) {
				$styles[] = 'background-color:' . $atts['content_background_color'];
			}

			return $styles;
		}

		private function get_text_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['text_color'] ) ) {
				$styles[] = 'color: ' . $atts['text_color'];
			}

			if ( ! empty( $atts['content_background_color'] ) ) {
				$styles[] = 'background-color:' . $atts['content_background_color'];
			}

			return $styles;
		}

		private function get_pin_styles( $atts ) {
			$styles = array();

			if ( ! empty( $atts['pin_color'] ) ) {
				$styles[] = 'color: ' . $atts['pin_color'];
			}

			return $styles;
		}
	}
}
