<?php

if ( ! function_exists( 'warren_core_add_price_list_shortcode' ) ) {
	/**
	 * Function that add shortcode into shortcodes list for registration
	 *
	 * @param array $shortcodes
	 *
	 * @return array
	 */
	function warren_core_add_price_list_shortcode( $shortcodes ) {
		$shortcodes[] = 'WarrenCore_Price_List_Shortcode';

		return $shortcodes;
	}

	add_filter( 'warren_core_filter_register_shortcodes', 'warren_core_add_price_list_shortcode' );
}

if ( class_exists( 'WarrenCore_Shortcode' ) ) {
	class WarrenCore_Price_List_Shortcode extends WarrenCore_Shortcode {

		public function map_shortcode() {
			$this->set_shortcode_path( WARREN_CORE_SHORTCODES_URL_PATH . '/price-list' );
			$this->set_base( 'warren_core_price_list' );
			$this->set_name( esc_html__( 'Price List', 'warren-core' ) );
			$this->set_description( esc_html__( 'Shortcode that adds price list holder', 'warren-core' ) );
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'custom_class',
					'title'      => esc_html__( 'Custom Class', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_tag',
					'title'         => esc_html__( 'Title Tag', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'title_tag' ),
					'default_value' => 'p',
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'title_font_style',
					'title'         => esc_html__( 'Title style', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'font_style' ),
					'default_value' => 'normal',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'text',
					'name'       => 'title_line_height',
					'title'      => esc_html__( 'Title Line Height', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type' => 'color',
					'name'       => 'title_color',
					'title'      => esc_html__( 'Title Color', 'warren-core' ),
				)
			);
			$this->set_option(
				array(
					'field_type'    => 'select',
					'name'          => 'link_target',
					'title'         => esc_html__( 'Link Target', 'warren-core' ),
					'options'       => warren_core_get_select_type_options_pool( 'link_target' ),
					'default_value' => '_self',
				)
			);
			$this->set_option(
				array(
					'field_type' => 'repeater',
					'name'       => 'children',
					'title'      => esc_html__( 'Price List Items', 'warren-core' ),
					'items'      => array(
						array(
							'field_type'    => 'text',
							'name'          => 'title',
							'title'         => esc_html__( 'Title', 'warren-core' ),
							'default_value' => '',
						),
						array(
							'field_type'    => 'text',
							'name'          => 'title_link',
							'title'         => esc_html__( 'Link', 'warren-core' ),
							'default_value' => '',
						),
						array(
							'field_type'    => 'text',
							'name'          => 'price',
							'title'         => esc_html__( 'Price', 'warren-core' ),
							'default_value' => '',
						),
					),
				)
			);
			$this->map_extra_options();
		}

		public function render( $options, $content = null ) {
			parent::render( $options );

			$atts                   = $this->get_atts();
			$atts['holder_classes'] = $this->get_holder_classes( $atts );
			$atts['this_object']    = $this;
			$atts['items']          = $this->parse_repeater_items( $atts['children'] );
			$atts['title_styles']   = $this->get_title_styles( $atts );

			return warren_core_get_template_part( 'shortcodes/price-list', 'templates/price-list', '', $atts );
		}

		private function get_holder_classes( $atts ) {
			$holder_classes = $this->init_holder_classes();

			$holder_classes[] = 'qodef-price-list';

			return implode( ' ', $holder_classes );
		}

		private function get_title_styles( $atts ) {
			$styles = array();

			$line_height = $atts['title_line_height'];
			if ( ! empty( $line_height ) ) {
				if ( qode_framework_string_ends_with_typography_units( $line_height ) ) {
					$styles[] = 'line-height: ' . $line_height;
				} else {
					$styles[] = 'line-height: ' . intval( $line_height ) . 'px';
				}
			}

			if ( ! empty( $atts['title_color'] ) ) {
				$styles[] = 'color: ' . $atts['title_color'];
			}

			if ( ! empty( $atts['title_font_style'] ) ) {
				$styles[] = 'font-style: ' . $atts['title_font_style'];
			}

			return $styles;
		}
	}
}
