(function ( $ ) {
	'use strict';

	var shortcode = 'warren_core_textual_project_showcase';

	qodefCore.shortcodes[shortcode] = {};

	if ( typeof qodefCore.listShortcodesScripts === 'object' ) {
		$.each(
			qodefCore.listShortcodesScripts,
			function ( key, value ) {
				qodefCore.shortcodes[shortcode][key] = value;
			}
		);
	}

	$( document ).ready(
		function () {
			qodefTextualProjectShowcase.init();
		}
	);

	var qodefTextualProjectShowcase = {
		init: function () {
			var $holder = $( '.qodef-textual-projects-showcase' );

			if ( $holder.length ) {
				$holder.each(
					function () {
						var $thisHolder = $( this );
						qodefTextualProjectShowcase.initItem( $thisHolder );
					}
				);
			}
		},
		initItem: function ( $currentHolder ) {
			if ( $currentHolder.hasClass( 'qodef--has-appear' ) ) {
				var $items = $currentHolder.find( '.qodef-e-text, .qodef-e-image' );

				qodef.qodefWaitForImages.check(
					$currentHolder,
					function () {

						qodefCore.qodefIsInViewport.check(
							$currentHolder,
							function () {
								if ( $items.length ) {
									$items.each(
										function ( i ) {
											var $item = $( this );

											setTimeout(
												() => $item.addClass( 'qodef--appeared' ),
												30 * i
											);
										}
									);
								}
							}
						);
					}
				);
			}
		},
	};

	qodefCore.shortcodes[shortcode].qodefTextualProjectShowcase = qodefTextualProjectShowcase;


})( jQuery );
