<?php
$spinner_images  = warren_core_get_post_value_through_levels( 'qodef_spinner_image_gallery' );

if ( isset( $spinner_images ) && ! empty( $spinner_images ) ) {
    $images = explode( ',', $spinner_images );
	$images = array_slice($images, 0, 4);
    ?>
    <div class="qodef-m-spinner-images">
        <?php
        foreach ( $images as $image ) {
	        $image_src   = wp_get_attachment_image_src( $image, 'full' );
		?>
            <span class="qodef-m-spinner-image">
	            <span class="qodef-m-spinner-image-inner">
                    <img itemprop="image" src="<?php echo esc_url( $image_src[0] ); ?>" width="<?php echo round( $image_src[1] / 2 ); ?>" height="<?php echo round( $image_src[2] / 2 ); ?>" alt="<?php echo esc_attr( $image_src[3] ); ?>" />
                </span>
            </span>
        <?php } ?>
    </div>
    <?php
}
?>

