<?php

if ( ! function_exists( 'warren_membership_add_login_opener_widget' ) ) {
	/**
	 * Function that add widget into widgets list for registration
	 *
	 * @param array $widgets
	 *
	 * @return array
	 */
	function warren_membership_add_login_opener_widget( $widgets ) {
		$widgets[] = 'WarrenMembership_Login_Opener_Widget';

		return $widgets;
	}

	add_filter( 'warren_membership_filter_register_widgets', 'warren_membership_add_login_opener_widget' );
}

if ( class_exists( 'QodeFrameworkWidget' ) ) {
	class WarrenMembership_Login_Opener_Widget extends QodeFrameworkWidget {

		public function map_widget() {
			$this->set_base( 'warren_membership_login_opener' );
			$this->set_name( esc_html__( 'Warren Login Opener', 'warren-membership' ) );
			$this->set_description( esc_html__( 'Login and register membership widget', 'warren-membership' ) );
			$this->set_widget_option(
				array(
					'field_type'  => 'text',
					'name'        => 'login_opener_margin',
					'title'       => esc_html__( 'Opener Margin', 'warren-membership' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left', 'warren-membership' ),
				)
			);
		}

		public function render( $atts ) {
			$classes   = array();
			$classes[] = is_user_logged_in() ? 'qodef-user-logged--in' : 'qodef-user-logged--out';

			$styles = array();

			if ( ! empty( $atts['login_opener_margin'] ) ) {
				$styles[] = 'margin: ' . $atts['login_opener_margin'];
			}

			$dashboard_template = apply_filters( 'warren_membership_filter_dashboard_template_name', '' );

			if ( empty( $dashboard_template ) || ! is_page_template( $dashboard_template ) || ( is_page_template( $dashboard_template ) && is_user_logged_in() ) ) { ?>
				<div class="qodef-login-opener-widget <?php echo implode( ' ', $classes ); ?>" <?php qode_framework_inline_style( $styles ); ?>>
					<?php warren_membership_template_part( 'widgets/login-opener', 'templates/holder' ); ?>
				</div>
				<?php
			}
		}
	}
}
