<?php

if ( ! function_exists( 'warren_load_page_mobile_header' ) ) {
	/**
	 * Function which loads page template module
	 */
	function warren_load_page_mobile_header() {
		// Include mobile header template
		echo apply_filters( 'warren_filter_mobile_header_template', warren_get_template_part( 'mobile-header', 'templates/mobile-header' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}

	add_action( 'warren_action_page_header_template', 'warren_load_page_mobile_header' );
}

if ( ! function_exists( 'warren_register_mobile_navigation_menus' ) ) {
	/**
	 * Function which registers navigation menus
	 */
	function warren_register_mobile_navigation_menus() {
		$navigation_menus = apply_filters( 'warren_filter_register_mobile_navigation_menus', array( 'mobile-navigation' => esc_html__( 'Mobile Navigation', 'warren' ) ) );

		if ( ! empty( $navigation_menus ) ) {
			register_nav_menus( $navigation_menus );
		}
	}

	add_action( 'warren_action_after_include_modules', 'warren_register_mobile_navigation_menus' );
}
